function dmri_response_estimation_prepare(fa_niftigz_file, output_niftigz_file)
% Preprocess FA image and get brain area for response function estimation.
%
% [Usage]
%    dmri_response_estimation_prepare(fa_niftigz_file, output_niftigz_file);
%
% [Input]
%        fa_niftigz_file : Fractional Anisotropy Image (.nii.gz)
%    output_niftigz_file : Preprocessed and extracted brain area(.nii.gz)
%
% [Output]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 2
    error('Please check input arguments.');
end
if exist(fa_niftigz_file, 'file') ~= 2
    error('Specified FA image not found.');
end

%
% --- Main Procedure
%
work_dir = tempname;
mkdir(work_dir);
[p, f, e] = fileparts(fa_niftigz_file);

% copy FA image to working directory.
fa_file   = fullfile(work_dir, filesep, [f, e]);
copyfile(fa_niftigz_file, fa_file);

% 1st step (thresholding)
tmp2_file = fullfile(work_dir, filesep, 'tmp2.nii.gz');
cmd = ['fslmaths' ...
       ' ', fa_file, ...
       ' -thr 0.7', ...
       ' -bin ', tmp2_file];
dmri_system(cmd);

% 2nd step (cluster)
tmp3_file = fullfile(work_dir, filesep, 'tmp3.nii.gz');
cmd = ['cluster', ...
       ' -i ', tmp2_file, ...
       ' -t 1',...
       ' -o ', tmp3_file];
dmri_system(cmd);

% 3rd step (get cluster value)
tmp4_file = fullfile(work_dir, filesep, 'max_cluster_val');
cmd = ['fslstats', ...
       ' ', tmp3_file, ...
       ' -R | cut -d '' '' -f 2 > ', tmp4_file];
dmri_system(cmd);
cmd = ['cat ', tmp4_file];
[s, value_str] = system(cmd);
value_str = strrep(value_str, sprintf('\n'), '');

% 4th step (extract brain area)
output_dir = fileparts(output_niftigz_file);
if exist(output_dir, 'dir') ~= 7
    mkdir(output_dir);
end
cmd = ['fslmaths', ...
       ' ', tmp3_file, ...
       ' -thr ', value_str, ...
       ' -uthr ' value_str, ...
       ' -bin '  output_niftigz_file];
dmri_system(cmd);

% copy value file to output_dir
copyfile(tmp4_file, output_dir);

% remove working directory
rmdir(work_dir, 's');
