function  Act = vb_try_atlas_correct(brainfile,atlasfile,atlas_id)
% Correct holes and islands in atlas label by morphology
%   [Atlas] = vb_try_atlas_correct
%   [Atlas] = vb_try_atlas_correct(brainfile,atlasfile,atlas_id)
% --- Optional Input
%  If input is not given, file name is asked by vb_file_select
% brainfile
% atlasfile
% atlas_id
% --- Output
% Atlas : structure of atlas label
% Atlas.xxP        : label value for each vertex
% Atlas.label      : label value
% Atlas.label_name : label_name corresponding to 'label'
% 
%
% 2006-11-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

DEBUG = 0;

if DEBUG == 1,
	proj_root = [getenv('MATHOME') '/Retino_TY'];
	MRI_ID    = 'Retino_TY';
	brainfile = [proj_root '/' MRI_ID '.brain.mat'];
	atlasfile = [proj_root '/' MRI_ID   '.atlas.mat' ];	
	atlas_id = 'aal';
	atlas_id = 'brodmann';
end

% Select Brain & Atlas file
if ~exist('brainfile','var')
	[pathname, filename] = vb_file_select({'.brain.mat'}, 'Select brain file');
	if isempty(filename), return; end;
	brainfile = fullfile(pathname, filename{1})
end

if ~exist('atlasfile','var')
	[pathname, filename] = vb_file_select({'.atlas.mat'}, 'Select atlas file');
	if isempty(filename), return; end;
	atlasfile = fullfile(pathname, filename{1})
end

if ~exist('atlas_id','var')
	prompt = 'Enter atlas key.';
	answer = inputdlg(prompt,'Atlas key',1, {'brodmann'});
	atlas_id = answer{1}
end

% Para.Rlabel : max radius for morphology  [m]
% Para.rate : number less than rate*(# of largest region) is deleted
switch	atlas_id
case	'aal'
	Para.Rlabel = 0.01;% [m]
	Para.rate   = 0.6;
case	'brodmann'
	Para.Rlabel = 0.012;% [m]
	Para.rate   = 0.3;
end

prompt = {['Enter elimination ratio.' ...
           ' Increasing it eliminate larger islands']};
answer = inputdlg(prompt,'Ratio',1, {num2str(Para.rate)});
Para.rate = str2num(answer{1})

% load atlas
Atlas = vb_get_act(atlasfile,atlas_id);

% Correct_atlas_label
switch	atlas_id
case	'aal'
	Act   = vb_correct_atlas_label(Atlas,brainfile,Para);
case	'brodmann'
	Act   = vb_correct_atlas_label_LR(Atlas,brainfile,Para);
end

vb_plot_atlas_area(brainfile,Act);

vb_plot_atlas2(brainfile,Act);

return
