function 	vb_save_correct_atlas(Atlas,atlasfile,atlas_id)
% Save atlas label
%  vb_save_correct_atlas(Atlas)
%  vb_save_correct_atlas(Atlas,atlasfile)
%  vb_save_correct_atlas(Atlas,atlasfile,atlas_id)
% --- Input
% Atlas : structure of atlas label
% --- Optional Input
%  If input is not given, file name is asked by vb_file_select
% atlasfile
% atlas_id
%
% 2006-11-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('atlasfile','var')
	[pathname, filename] = vb_file_select({'.atlas.mat'}, 'Select atlas file');
	if isempty(filename), return; end;
	atlasfile = fullfile(pathname, filename{1})
end

if ~exist('atlas_id','var')
	prompt = 'Enter atlas key for save';
	answer = inputdlg(prompt,'Atlas key',1, {Atlas.key});
	atlas_id = answer{1}
end

Atlas.key = atlas_id;

vb_add_act(atlasfile , Atlas);

[pathname, fname] = fileparts(atlasfile);

areafile = fullfile(pathname, [atlas_id '.area.mat'])

vb_save_atlas_label(areafile, Atlas.xxP, Atlas.label, Atlas.label_name);
