function	list = vb_get_brodmann_area_list(Nlist)
% Get list of brodmann area number for plot
%  brodmann area numbers are devided into set of area number list
%  area_list = vb_get_brodmann_area_list(Nlist)
%  Nlist : number of area list
%  area_list : area list cell array 
%  area_list{n} : n-th area list
%  If Nlist = 0, the following list is returned
%  area_list ={...
%	[1 2 3 4 5]; ...
%	[6 7] ; ...
%	[8 9 10 11] ; ...
%	[17 18 19] ; ...
%	[20 21 22]  ; ...
%	[23 24 ] ; ...
%	[25 26 27 28 29 30] ; ...
%	[32 36 38]  ; ...
%	[37 39] ; ...
%	[40:44] ; ...
%	[45:47] ; ...
%	};
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%ʬ䤹  [ 6, 18, 19, 20]
%
%礹  [1 2 ] 
%礹  [23 24} { 25 26 27 28 29 30}
%礹  [36 38] [41 42 43] 

% label = 1:47
% label_L = label;
% label_R = label + 1000;

if nargin==0, Nlist = 0; end;

if Nlist > 0
	Nmax = 47;
	Nstep = ceil(Nmax/Nlist);
	slist = 1:Nstep:Nmax;
	elist = slist + Nstep - 1;
	elist = min(elist,Nmax);
	list  = cell(Nlist,1);
	for n=1:Nlist
		list{n} = slist(n):elist(n);
	end
elseif Nlist < 0
	list ={...
	[1 2 3 4 5]; ...
	[17 18 19] ; ...
	};
else
	list ={...
	[1 2 3 4 5]; ...
	[6 7] ; ...
	[8 9 10 11] ; ...
	[17 18 19] ; ...
	[20 21 22]  ; ...
	[23 24 ] ; ...
	[25 26 27 28 29 30] ; ...
	[32 36 38]  ; ...
	[37 39] ; ...
	[40:44] ; ...
	[45:47] ; ...
	};
end
