function	Vlabel = vb_fill_atlas_label(brainfile, Vlabel, ix, Rlimit)
% Fill label referring neighbor point label along cortex
%  Vlabel = fill_label(brainfile, Vlabel, ix, Rlimit)
%
%  Vlabel : label for each vertex point
%  ix     : unlabeld vertex index
%  Rlimit : max radius referring neighbor point
%  brainfile : brain file name
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[nextDD,nextIX] = vb_load_cortex_neighbour(brainfile);

NV  = length(Vlabel);
flg = zeros(NV,1);

flg(ix) = 1;
Vlabel(ix) = 0;
N = length(ix);

Nmax = 2*N;
cnt  = 0;

while N > 0
	for n=1:N
		j  = ix(n);
		dd = nextDD{j};
		jj = nextIX{j};
		val = Vlabel(jj);
		
		jx = find( val > 0 );
		[dmin, jmin] = min( dd(jx) );
		
		if dmin < Rlimit
			Vlabel(j) = val(jx(jmin));
			flg(j)=0;
		end
	end
	
	ix = find( flg > 0 );
	N = length(ix);
	cnt = cnt + 1;
	if cnt > Nmax, break; end
end

