function	[Atlas,result] = vb_correct_atlas_label(Atlas,brainfile,Para)
% Correct holes and islands in atlas label
%   [Atlas] = vb_correct_atlas_label(Atlas,brainfile)
% --- Input
% Atlas : structure of atlas label
% Atlas.xxP        : label value for each vertex
% Atlas.label      : label value
% Atlas.label_name : label_name corresponding to 'label'
% 
% brainfile
%
% Para.Rlabel : max radius for morphology  [mm]
% Para.rate : number less than rate*(# of largest region) is deleted
% Para.Nmin : number less than Nmin is deleted
% --- Output
% Atlas : structure of atlas label
% --- Method
% extract connected region
% fill holes by gaussian filter morphology
%
% 2006-11-12 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


if ~exist('Para','var'), Para = []; end

% max radius for morphology
if isfield(Para,'Rlabel')
	Rmax  = Para.Rlabel/1000; % [mm] -> [m]
else
	Rmax  = 0.01;% [m]
end
if isfield(Para,'rate')
	rate  = Para.rate;
else
	rate  = 0.1;
end
if isfield(Para,'Nmin')
	Nmin  = Para.Nmin;
else
	Nmin  = 10;
end

% load brain
[V, F] = vb_load_cortex(brainfile);

F	 = F.F3;		% patch index
NV   = size(V,1);	% # of vertex

label = Atlas.label      ; % label value;
Narea = length(label);

% label value for each vertex [Nvertex x 1]
xxP = Atlas.xxP; 
xxQ = zeros(NV,1);

Num0 = sum( xxP == 0 );
fprintf('--- Unlabeled vertex = %d\n',Num0)
fprintf('--- Find connected region\n')

% --- Remove label for small disconnected region
for n=1:Narea
    % vertex index for n-th label
    ix = find( xxP == label(n) );
    
    if isempty(ix), continue; end;
    
    % find connected region
	[Vindx, Nall] = vb_connected_vertex(ix,F);
	
	% set label to large connected region
	if ~isempty(Vindx)
		% set label for largest region
		xxQ([Vindx{1}]) = label(n);
		
		jj = find( (Nall >= Nall(1)*rate) & (Nall > Nmin) );
		
		for m=1:length(jj)
			xxQ([Vindx{jj(m)}]) = label(n);
		end
	end
	
end

Num = sum( xxQ == 0 );

fprintf('--- Unlabeled vertex after removal = %d\n',Num)
fprintf('--- Label filling\n')

% unlabeled index
ixfix = find( xxQ == 0 );
Nfix  = length(ixfix);

% label weight for unlabeled points
PP = zeros(Nfix,Narea);

% smoothing filter
W  = vb_spatial_gauss_filter(brainfile,Rmax,Rmax,[1:NV]);
W  = W(ixfix,:);

for n=1:Narea
    % vertex index for n-th label
    ix = find( xxQ == label(n) );
    
    if isempty(ix), continue; end;
    
    % Gaussian filtering from n-th labeled points
    PP(:,n) = sum(W(:,ix), 2);
	
end

% --- Label filling
for n=1:Nfix
	% find maximum weighted label
	[Pmax, id] = max(PP(n,:));
	
	if Pmax > 0,
		xxQ(ixfix(n)) = label(id);
	end
end

%xxP = xxQ;
%xxQ = zeros(NV,1);
%
%for n=1:Narea
%    % vertex index for n-th label
%    ix = find( xxP == label(n) );
%    
%    if isempty(ix), continue; end;
%    
%    % find connected region
%	[Vindx, Nall] = vb_connected_vertex(ix,F);
%	
%	% set label to large connected region
%	if ~isempty(Vindx)
%		% set label for largest region
%		xxQ([Vindx{1}]) = label(n);
%		
%		jj = find( (Nall >= Nall(1)*rate) & (Nall > Nmin) );
%		
%		for m=1:length(jj)
%			xxQ([Vindx{jj(m)}]) = label(n);
%		end
%	end
%	
%end

Atlas.xxP = xxQ;

Num2 = sum( xxQ == 0 );
fprintf('--- Final unlabeled vertex = %d\n',Num2)

if Num2 >= Num, 
	result = 0;
else 
	result = 1; 
end

%%% surface morphology
%	Iextract = vb_open_area(Jarea, R, nextIX, nextDD);
%	Iextract = vb_close_area(Jarea, R, nextIX, nextDD);
