function [meg_parm] = vb_set_yokogawa_meg_parm_test(device_code)
% set values to the meg_parm for vb_job_meg
% [usage]
%   [meg_parm] = vb_set_yokogawa_meg_parm_test(device_code)
% [input]
%   device_code : <optional> device code for 1) MEG or 2) EEG
%               :  default is [1]
% [output]
%      meg_parm : <<struct>> meg_parm
% [note]
%
% [history]
%   2008-01-23 (Sako) initial version
%   2008-01-31 (Sako) deleted some fields to standardize
%   2008-03-28 (Sako) supported pos-mat file
%   2011-02-18 (Sako) changed value of parameter which has default value
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('device_code', 'var') || isempty(device_code)
  device_code = 1;
end

func_ = mfilename;

% --- MEG --- %
if device_code == 1


  % --- REQUIRED --------------------------------------------------- %

  meg_parm = vb_meg_parm_set_measurement([], 'MEG', 'YOKOGAWA');

%   meg_parm.yokogawa_file   = 'NH.con';
%   meg_parm.yokogawa_file   = 'NH.ave';
%   meg_parm.yokogawa_file   = 'NH.raw';
  % if following saveman is valid and yokogawa file type is ...
  %  *.con [Continuous Raw] --> channel binary file
  %  *.ave [Evoked Ave] ------> channel binary file
  %  *.raw [Evoked Raw] ------> trial binary file

%   meg_parm.yokogawa_file   = 'NH.con';
%   meg_parm.yokogawa_file   = 'NH.ave';
%   meg_parm.yokogawa_file   = 'NH.raw';
  % if following saveman is valid and yokogawa file type is ...
  %  *.con [Continuous Raw] --> channel binary file
  %  *.ave [Evoked Ave] ------> channel binary file
  %  *.raw [Evoked Raw] ------> trial binary file
  
  % --- actually MEG-MAT file will be made in "<proj_root>/meg_parm.meg_file"
  meg_parm.meg_file        = 'initial.meg.mat';

  data_dir = '.\databox';
  pos_file_name = [ data_dir filesep 'tmp.pos.mat'];
  meg_parm.pos_file = pos_file_name;

  
  % internal parameter
  % --- default is 10000000 (10M)
  meg_parm.memory_max      = [];


  % --- OPTIONAL --------------------------------------------------- %
  meg_parm.ex_ch_gain      = [];

% --- the way to set ex_ch_gain is like as follows
%   meg_parm.ex_ch_gain.name = '224';
%   meg_parm.ex_ch_gain.value =100;
%   meg_parm.ex_ch_gain(2).name = '225';
%   meg_parm.ex_ch_gain(2).value = 100;
%   meg_parm.ex_ch_gain(3).name = '226';
%   meg_parm.ex_ch_gain(3).value = 110;

else
  error('(%s)undefined device_code : %d', func_, device_code);
end

%%% END OF FILE %%%
