function [meg_parm] = vb_set_yokogawa_meg_parm(device_code)
% set values to the meg_parm for vb_job_meg
% [usage]
%   [meg_parm] = vb_set_yokogawa_meg_parm(device_code)
% [input]
%   device_code : <optional> device code for 1) MEG or 2) EEG
%               :  default is [1]
% [output]
%      meg_parm : <<struct>> structure with following field
%               :   <<fields>>
%               :   .yokogawa_file : <required> <<file>> YOKOGAWA-MEG file
%               :                  :  .con | .ave | .raw
%               :   .meg_file      : <required> Output MEG file.
%               :                  :  This is used in connecting to proj_root.
%               :                  : [proj_root '/' <meg_parm.meg_file>] : 
%               :   .pos_file      : <optional> <<file>> POS-MAT file
%                                      This is made by positioning program.
%               :                  :   the members of which are as follows
%               :                  :    mri_key   - hash key [x1 string]
%               :                  :    coord_type- coordinate type [x1 string]
%               :                  :    pos       - coordinate [Nch x3 double]
%               :                  :    name      - channel name [Nch x1 string]
%               :                  :    trans_mri - transform matrix [4x4 double]
%               :                  :    header    - header information <<struct>>
%               :                  :      .digit_file_name : <optional>
%               :                  :      .meg_market_id : <optional>
%               :   .ex_ch_gain    : <optional> gain of extra channel[]
% [note]
%  @see vb_set_yokogawa_meg_parm_test.m
%
% [history]
%   2008-01-23 (Sako) initial version
%   2008-01-31 (Sako) deleted some fields to standardize
%   2008-03-28 (Sako) supported pos-mat file
%   2011-02-17 (Sako) got rid of old comments and unnecessary settings
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('device_code', 'var') || isempty(device_code)
  device_code = 1;
end

func_ = mfilename;

% --- MEG --- %
if device_code == 1


  % --- REQUIRED --------------------------------------------------- %

  meg_parm = vb_meg_parm_set_measurement([], 'MEG', 'YOKOGAWA');

%   meg_parm.yokogawa_file   = 'NH.con';
%   meg_parm.yokogawa_file   = 'NH.ave';
%   meg_parm.yokogawa_file   = 'NH.raw';
  % if following saveman is valid and yokogawa file type is ...
  %  *.con [Continuous Raw] --> channel binary file
  %  *.ave [Evoked Ave] ------> channel binary file
  %  *.raw [Evoked Raw] ------> trial binary file

  meg_parm.yokogawa_file   = '';
%   meg_parm.yokogawa_file   = 'NH.con';
%   meg_parm.yokogawa_file   = 'NH.ave';
%   meg_parm.yokogawa_file   = 'NH.raw';
  % if following saveman is valid and yokogawa file type is ...
  %  *.con [Continuous Raw] --> channel binary file
  %  *.ave [Evoked Ave] ------> channel binary file
  %  *.raw [Evoked Raw] ------> trial binary file
  
  % --- actually MEG-MAT file will be made in "<proj_root>/meg_parm.meg_file"
  meg_parm.meg_file        = '';

  meg_parm.pos_file = '';

  
  % internal parameter
  meg_parm.memory_max      = [];


  % --- OPTIONAL --------------------------------------------------- %
  meg_parm.ex_ch_gain      = [];

% --- the way to set ex_ch_gain is like as follows
%   meg_parm.ex_ch_gain.name = '224';
%   meg_parm.ex_ch_gain.value =100;
%   meg_parm.ex_ch_gain(2).name = '225';
%   meg_parm.ex_ch_gain(2).value = 100;
%   meg_parm.ex_ch_gain(3).name = '226';
%   meg_parm.ex_ch_gain(3).value = 110;

else
  error('(%s)undefined device_code : %d', func_, device_code);
end

%%% END OF FILE %%%
