function [eeg_parm] = vb_set_meg_parm_biosemi_test(device_code,session_no)
% set values to the eeg_parm for vb_job_meg (BIOSEMI)
% [usage]
%   [eeg_parm] = vb_set_meg_parm_biosemi_test(device_code,session_no)
% [input]
%   device_code : <optional> device code for 1) BIOSEMI
%               :  default is [1]
%    session_no : <required> session number []
% [output]
%      eeg_parm : <<struct>> eeg_parm
%               :  .Measurement      : 'EEG'
%               :  .device           : 'BIOSEMI'
%               :  .measurement_file : input file (normally *.bdf)
%               :  .pos_file         : position file (*.pos.mat)
%               :  .output_file      : output file (normally *.eeg.mat)
% [note]
%
% [history]
%   2008-02-14 (Sako) initial version
%   2008-02-26 (Sako) supported POS-MAT file
%   2008-03-18 (Sako) discarded figure_info
%   2008-04-03 (Sako) move device field to the same location of MEG (why?)
%   2008-05-26 Masa-aki Sato
%     added eeg_parm.meg_file  for consistency with meg data
%     added eeg_parm.face_file for sensor plot
%     added session_no
%     changed meg_parm to eeg_parm
%   2008-05-28 (Sako) changed format of eeg_parm
%   2011-02-18 (Sako) changed comment of bin_data_dir and deleted unused fields
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('device_code', 'var') || isempty(device_code)
  device_code = 1;
end

func_ = mfilename;

% --- EEG --- %
if device_code == 1
  % --- REQUIRED --------------------------------------------------- %
  eeg_parm = vb_meg_parm_set_measurement([], 'EEG', 'BIOSEMI');
  
  % some working variables
  data_dir = [getenv('MATHOME') '/EEG-NIRS_20080423/RawEEG/'];
  pos_dir  = [getenv('MATHOME') '/EEG-NIRS_20080423/Positioning/'];
  subject  = 'Takao_Sako';
  eeg_id   = [...
    '20080408_175108';
	'20080408_180210';
	'20080408_181507';
	'20080408_182503';
	'20080408_183515';
	'20080408_184615';
	'20080408_185631';
	'20080408_190536';
	];
  eeg_name = eeg_id(session_no,:);
  
  % --- Setting to read BDF file
  % --- Input Raw data path - absolute path
  eeg_parm.measurement_file = [data_dir 'Sako_' eeg_name '.bdf'];

  % --- Input Positioning data path - absolute path
  eeg_parm.pos_file = [pos_dir subject '.pos.mat'];

  % --- Output EEG-MAT file - relative path from 'proj_root'
  eeg_parm.output_file = [eeg_name '.eeg.mat'];
  
else
  error('(%s)undefined device_code : %d', func_, device_code);
end

%%% END OF FILE %%%
