function [meg_parm] = vb_set_meg_parm_biosemi(device_code)
% set values to the meg_parm for vb_job_meg (BIOSEMI)
% [usage]
%   [meg_parm] = vb_set_meg_parm_biosemi(device_code)
% [input]
%   device_code : <optional> device code for 1) BIOSEMI
%               :  default is [1]
% [output]
%      meg_parm : <<struct>> meg_parm
%               :  .Measurement      : 'EEG'
%               :  .device           : 'BIOSEMI'
%               :  .measurement_file : input file (normally *.bdf)
%               :  .pos_file         : position file (*.pos.mat)
%               :  .output_file      : output file (normally *.eeg.mat)
% [note]
%   @see vb_set_meg_parm_biosemi_test.m
% [history]
%   2008-02-14 (Sako) initial version
%   2008-02-26 (Sako) supported POS-MAT file
%   2008-03-18 (Sako) discarded figure_info
%   2008-05-28 (Sako) changed format of meg_parm
%   2011-02-18 (Sako) changed value of bin_data_dir empty
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('device_code', 'var') || isempty(device_code)
  device_code = 1;
end

func_ = mfilename;

% --- EEG --- %
if device_code == 1

  % --- REQUIRED --------------------------------------------------- %

  meg_parm = vb_meg_parm_set_measurement([], 'EEG', 'BIOSEMI');
  
  meg_parm.measurement_file   = '';
  meg_parm.pos_file   = '';
  meg_parm.output_file = '';
else
  error('(%s)undefined device_code : %d', func_, device_code);
end

%%% END OF FILE %%%
