function	head_parm = vb_set_head_parm_eeg_test
% Set parameters for head model
%   head_parm = set_head_parm_test
%     Absolute path
%  head_parm.brain_mask = 
%  head_parm.analyze_file = 
%  head_parm.subj_mask    = 
%  head_parm.face_file    = 
%  head_parm.snfile       = 
%  head_parm.brain_file   = 
%    Relative path from proj_root
%  head_parm.curry_file = 
%  head_parm.head_file = 
%  
%
% 2008-10-06 Masa-aki Sato
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% root data dir for subject (working variable)
user_root = getenv('MATHOME');
HEAD = [user_root '/EEG-NIRS_20080423/Curry/'];
MRI  = [user_root '/EEG-NIRS_20080423/MRI/'];
Subj = [user_root '/EEG-NIRS_20080423/subject/'];

% --- Input MRI image file (Analyze or Nifty)
%     Absolute path
head_parm.analyze_file = [MRI '3D_T1.nii' ]; 
head_parm.face_file    = [MRI 'ST.face.mat'];
head_parm.brain_file   = [Subj 'SKbrain.brain.mat'];

% --- Input Head surface file made by Curry (TEXT-file)
%     Absolute path
head_parm.curry_file = [HEAD 'TS_T1.s00']; % inner skull (CSF)

% --- Output Head surface file (MAT-file)
%     Relative path from proj_root

% MEG : 1-shell model (1 file)
% head_parm.head_file = 'SKhead.head.mat';

% EEG : 3-shell model (3 file in cell array)
head_parm.head_file = {...
	 'SK_csf.head.mat';
	 'SK_skull.head.mat';
	 'SK_scalp.head.mat';
};

% Vertex number of one smoothed head surface 
% The same number is assumed for 3-shell surface
head_parm.Nvertex = 2000; 

%
% --- Advanced parameters 
%  Do not change, unless you understand the meaning of the parameters!!
%

% Morphological radius for Curry surface smoothing ( = [ 4 -4 ])
head_parm.Radius  = [ 4 -4 ]; % 4 mm dilation & 4mm erosion

% EEG : 3-shell model case (Optional)
% Morphological  radius for Skull & Scalp 
head_parm.Scalp  = [ 8 ]; % Max width of skin  [mm] 
%head_parm.Skull  = [ 6 ]; % Min width of skull [mm]

head_parm.Nloop = 200; %  : Iteration number of expand to boundary ( = 200)
head_parm.Nlast = 5;  %  : Iteration number of surface smoothing   ( = 5 )

% --- spring surface model
head_parm.tangent_rate   = 0.3; % Rate of smoothing force ( = 0.3)
head_parm.mask_ratio     = 0.5; % Rate of mask force ( = 0.5)
head_parm.mask_threshold = 0.3; % threshold for in/out boundary

head_parm.vstep	 = 2  ; % Subsampling step for mask image [mm]


