function [Measurement, Device] = vb_meg_parm_get_measurement(meg_parm)
% Return Measurement and device from meg_parm.
% [USAGE]
%    [Measurement, Device] = vb_meg_parm_get_measurement(<meg_parm>);
% [IN]
%    meg_parm : meg_parm for device.
% [OUT]
%    Measurement : Measurement type
%         Device : device type
% [NOTE]
%    @see : vb_meg_parm_set_measurement()
%    If Measurement or device fields do not exists(or empty), 
%    this function starts deciding Measurement and device.
%    But it failed, return empty.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('meg_parm', 'var')
  error('meg_parm is a required parameter.');
end

%
% --- Main Procedure
%
Measurement = '';
Device      = '';

if isfield(meg_parm, 'Measurement') && ~isempty(meg_parm.Measurement)
  Measurement = meg_parm.Measurement;
end
if isfield(meg_parm, 'device') && ~isempty(meg_parm.device)
  Device = meg_parm.device;
end

if ~isempty(Measurement) && ~isempty(Device)
  return;
end

% rescue start
if isfield(meg_parm, 'yokogawa_file')
  Measurement = 'MEG';
  Device      = 'YOKOGAWA';
elseif isfield(meg_parm, 'sbi_file')
  Measurement = 'MEG';
  Device      = 'SBI';
elseif isfield(meg_parm, 'measurement_file')
  Measurement = 'EEG';
  Device      = 'BIOSEMI';
else
  % do nothing (return empty)
end
