function h=vb_epsfig(fig,rxy,PW)
% Set Paper position for EPS-File
%
% rxy = H/W (Hight/Width raio for output)
% PW  = Paper width in centimeters
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin<1,fig=figure;end
if nargin<2,rxy=1;end;
if nargin<3,PW=20;end;

% Paper Position in centimeters

PH=rxy*PW;
PL=0.8;
PB=0.5;

Ppos=[PL PB PW PH];

% r=(Figure Hight)/(Screen Hight)

r=0.7;

Wmargin=50;
Hmargin=130;

Scr=get(0,'ScreenSize');
W=Scr(3);
H=Scr(4);

SHW=H/W;

if rxy >= SHW,
	FH=H*r;
	FW=FH/rxy;
else
	FW=W*r;
	FH=FW*rxy;
end;

FL=W-FW-Wmargin;
FB=H-FH-Hmargin;

Fpos=[FL FB FW FH];

set(fig,...
  'PaperUnits','centimeters',...
  'Position', Fpos,...
  'PaperOrientation','portrait',...
  'PaperPosition',Ppos);


%  'PaperType','a4letter',...
%  'NumberTitle', 'off',...
%  'PaperPosition',[2.2 1.0 27 20]);

h=fig;

%
