function	vb_plot_vertex(V, vdim, indx, dz, Msize, Mtype, mode)
% plot vertex on Analyze slice image 
%
% V    ;: Vertex 3D-coordinate [ Nvertex, 3 ]
% indx : slice index in vdim-axis
% dz   : slice width
%        V(:,az) >= (indx-dz) & V(:,az) <= (indx+dz)
% vdim : slice cut direction
%      = 'x' : Sagittal cut : Y-Z plane
%      = 'y' : Coronal cut : X-Z plane
%      = 'z' : Transverse (Axial) cut : X-Y plane
% mode : 2D plot mode for X-Y 
%      = 0   : plot without transpose
%      = 1   : plot by transposing 2D-image matrix
% Msize : Marker size
% Mtype : Marker type
%
% written by M. Sato  2005-8-1
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


if nargin<4, dz=1.5; end;
if nargin<5, Msize=1; end;
if nargin<6, Mtype = 'y.'; end;
if nargin<7, mode=0; end;

switch	vdim
case	'x',
	% 'SAG' : Sagittal cut : Y-Z plane
	ax = 2;
	ay = 3;
	az = 1;
case	'y',
	% 'COR' : Coronal cut : X-Z plane
	ax = 1;
	ay = 3;
	az = 2;
case	'z',
	% 'TRN' : Transverse (Axial) cut : X-Y plane
	ax = 1;
	ay = 2;
	az = 3;
end

% vertex plot
ix = find( V(:,az) >= (indx-dz) & V(:,az) < (indx+dz));
Nv = length(ix);

switch	mode
case	0,
	X  = V(ix,ax);
	Y  = V(ix,ay);
case	1,
	X  = V(ix,ay);
	Y  = V(ix,ax);
end

plot(X,Y,Mtype,'MarkerSize',Msize);

