function [h1,h2,h3] = vb_plot_slice2(B,V_bv,V,xxP,indx,PARA)
%
% B(ix,iy,iz) : fMRI slice data
% V(n,:)      : Vertex coordinate Boxel-coordinate[mm]
% V = [Vx, Vy, Vz] <-> [iy, ix, iz]
% image(B(i1,i2)) : [ i2 , i1 ]<-> [ x , y ]
% xxP(n)    : Activity at V(n,:)
% indx      : slice index
% vdim      : slice-cut axis
% PARA.width: Half width to plot active points
% PARA.msize: Marker size for fMRI active point
%
% Originaly written by S.Kajihara
% Ver 1.0  modified by M. Sato  2003-3-15
%
% 2004-04-23 modified by T. Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

vdim = PARA.vdim;

% Color map
cmap2=colormap('jet'); %colormap('cool'); 

[NBx,NBy,NBz]=size(B);

switch	vdim,
case	1,%'TRN'
    x=3; y=1; z=2;
    B2=reshape(B(indx,:,:),NBy,NBz);
%    [x1,y1]=meshgrid([1:NBz],[1:NBy]);
%    [x2,y2]=meshgrid([1:NBz],[1:NBy]);
%    B3=interp2(x1,y1,B2,x2,y2,'linear');
case	2,%'COR'
    x=3; y=2; z=1;
    B2=reshape(B(:,indx,:),NBx,NBz);
%    [x1,y1]=meshgrid([1:NBz],[1:NBx]);
%    [x2,y2]=meshgrid([1:NBz],[1:NBx]);
%    B3=interp2(x1,y1,B2,x2,y2,'linear');
case	3,%'SAG'
    x=1; y=2; z=3;
%    B3=B(:,:,indx);
    B2=B(:,:,indx);
end;

% display MRI
%h=image(B3,'CDataMapping','scaled');
hold off;
h1=image(B2,'CDataMapping','scaled');

colormap('gray'); 
axis('equal'); 
axis('tight');
hold on;

tstr = {'Up-down cut'; 'Front-back cut'; 'Left-right cut'};

isl0 = indx;
isl1 = isl0 - PARA.width;
isl2 = isl0 + PARA.width;

% BV points
if ~isempty(V_bv)
  pix  = find(V_bv(:,z)>=isl1-0.5 & V_bv(:,z)<isl2+0.5);
  Vdisp=V_bv(pix,:);
  X=Vdisp(:,x);
  Y=Vdisp(:,y);
  h2 = plot(X,Y, PARA.mtype,'MarkerSize',PARA.msize);
else
  h2 = [];
end

% Active points
if ~isempty(V)
  xxP_max = max(abs(xxP))*PARA.wmax;
  xxP_min = max(abs(xxP))*PARA.wmin;
  pix  = find(V(:,z)>=isl1-0.5 & V(:,z)<isl2+0.5 ...
	      & xxP<=xxP_max & xxP>=xxP_min);
  Vdisp=V(pix,:);
  X=Vdisp(:,x);
  Y=Vdisp(:,y);
  activity = fix(xxP(pix)/max(xxP)*63)+1;
  h3 = scatter(X,Y, 2*PARA.msize, cmap2(activity,:), 'filled');
else
  h3 = [];
end

title(sprintf('%s (%d - %d)',tstr{vdim},isl1,isl2));
