function vb_plot_sensor_2d_head_plot_add(vb_plot_sensor_2d_axes_h)

% delete previous plot face line
face_handles = getappdata(vb_plot_sensor_2d_axes_h, 'face_handles');
if ~isempty(face_handles)
    for k=1:length(face_handles)
        try
            delete(face_handles(k));
        catch
        end
    end
    face_handles = [];
end

% get contourmap data
children = get(vb_plot_sensor_2d_axes_h, 'children');
if vb_matlab_version('<', '8.4')
    group    = findobj(children, 'Type', 'hggroup');
    hg       = group(1);
else
    hg       = children(end);
end

Xdata = get(hg, 'Xdata');
Ydata = get(hg, 'Ydata');
Xmin = min(min(Xdata));
Ymin = min(min(Ydata));
Xmax = max(max(Xdata));
Ymax = max(max(Ydata));
rmax = (Ymax - Ymin)/2;

% cited codes from topoplot.m(EEGLAB) and modified. Thank you.
l = 0:2*pi/100:2*pi;
tip = rmax*1.15; base = rmax-0.04;
EarX = [.497 .510 .518 .5299 .5419 .54 .547 .532 .510 .489]/0.5*rmax;
EarY = [.0555 .0775 .0783 .0746 .0555 -.0055 -.0932 -.1313 -.1384 -.1199]/0.5*rmax;
HCOLOR = [0 0 0];
HLINEWIDTH = 2;
% Plot Head, Ears, Nose
h1 = plot(vb_plot_sensor_2d_axes_h, cos(l).*rmax,sin(l).*rmax,...
          'color',HCOLOR,'Linestyle','-','LineWidth',HLINEWIDTH);

h2 = plot(vb_plot_sensor_2d_axes_h, [.1*rmax/0.5;0;-.1*rmax/0.5],-1*[base;tip;base],...
           'Color',HCOLOR,'LineWidth',HLINEWIDTH);

h3 = plot(vb_plot_sensor_2d_axes_h, EarX,EarY,'color',HCOLOR,'LineWidth',HLINEWIDTH);
h4 = plot(vb_plot_sensor_2d_axes_h,-EarX,EarY,'color',HCOLOR,'LineWidth',HLINEWIDTH);  
xlim([Xmax*-1.2 Xmax*1.2]); ylim([Ymax*-1.2 Ymax*1.2]);

face_handles = [h1,h2,h3,h4];
set(face_handles, 'HandleVisibility', 'off');
setappdata(vb_plot_sensor_2d_axes_h, 'face_handles', face_handles);

