function	vb_plot_head_mask(B,indx,vdim,V1,F1,V2,F2)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% plot analyze data
xymode = 0; %  2D plot mode for X-Y  ( = 0 or 1)
Mtype =  {'r-'; 'b-'} ;

Vmax = max(V1,[],1);
Vmin = min(V1,[],1);

if isempty(indx) 
	if	isempty(vdim)
		vdim  = ['z','z','z','x','x','x']; 
		Nslice = 3;
		Vstp = (Vmax - Vmin)/(Nslice+1);
		xinx = fix((1:Nslice)*Vstp(1) + Vmin(1));
		zinx = fix((1:Nslice)*Vstp(3) + Vmin(3));
		indx = [zinx xinx];
	elseif	length(vdim)==1
		Nslice = 6;
		Vstp = (Vmax - Vmin)/(Nslice+1);
		switch	vdim
		case	'x'
			indx = fix((1:Nslice)*Vstp(1) + Vmin(1));
		case	'y'
			indx = fix((1:Nslice)*Vstp(2) + Vmin(2));
		case	'z'
			indx = fix((1:Nslice)*Vstp(3) + Vmin(3));
		end
		vdim = repmat(vdim, [1 Nslice]);
	end
end

dmax  = 10; 
Nfig  = length(indx);
Msize = 1;

NY = 2;
NX = ceil(Nfig/NY);

for n=1:Nfig
	subplot(NY,NX,n)
	
	if ~isempty(B)
		vb_plot_3d_image(B, indx(n), vdim(n), xymode);
		axis('equal'); 
		axis('tight');
		colormap(gray);
		title(sprintf('%s = %d',vdim(n),indx(n)))
		hold on
	end
	if exist('V1','var')
		vb_plot_cross_section(V1,F1,indx(n),vdim(n),...
		                  dmax,Msize,Mtype{1},xymode);	
	end
	if exist('V2','var')
		vb_plot_cross_section(V2,F2,indx(n),vdim(n),...
		                  dmax,Msize,Mtype{2},xymode);	
	end
end
