function	vb_check_sphere_slice(brainfile,megfile,analyzefile,Vradius)
% Check sphere model
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('Vradius','var') || isempty(Vradius)
	Vradius = 75; 
else 
	Vradius = Vradius*1000; 
end

%analyzefile = brain_parm.analyze_file;
%brainfile   = [proj_root '/' brain_parm.brain_file];
%megfile     = [proj_root '/' meg_parm.meg_file];

if ~exist(analyzefile,'file'), 
	fprintf('There is no analyze file: %s\n',analyzefile)
	fprintf('Check of sphere model is skipped\n')
	return
end

if iscell(megfile), megfile = megfile{1}; end;

% Load sensor and sphere center position
[pick,Qpick,Wsensor,Vcenter] = vb_load_sensor(megfile);

% Load brain model
[V] = vb_load_cortex(brainfile, 'subj');

% Load MRI image
[B, Vdim, Vsize] = vb_load_analyze_to_right(analyzefile);

% Change coordinate to analyze_right voxcel coordinate
Scenter = vb_spm_right_to_analyze_right(Vcenter(:)',Vdim,Vsize);
Vana    = vb_spm_right_to_analyze_right(V,Vdim,Vsize);

vdim    = ['x';'y';'z'];
sindx   = round(Scenter);
xyindx  = [ 2 3 ; 1 3; 1 2];
step    = 1;
xymode  = 0;
Msize   = 4;		% marker size
Mtype   = 'y.';		% marker type

NX = 3; NY = 1;

T = 1000;
t = (0:T)*(2/T);
x = Vradius*cos(pi*t);
y = Vradius*sin(pi*t);

figure;

for n=1:3
	subplot(NY,NX,n);
	vb_plot_3d_image(B,sindx(n),vdim(n),xymode);
	hold on
	vb_plot_vertex(Vana, vdim(n), sindx(n), step, Msize, Mtype, xymode);
	plot(x/Vsize(n) + Scenter(xyindx(n,1)), y/Vsize(n) + Scenter(xyindx(n,2)), '-r');
end

subplot(NY,NX,2);
title('Sphere and cortex model on MRI slice')

%   vb_plot_3d_image(B,indx,vdim,mode,V)
%
% B : 3D-image [NBx, NBy, NBz]. The coordinate system must be RAS. 
%     Note that the default of ANALYZE coordinate is LAS. 
% indx : slice index in vdim-axis
% vdim : slice cut direction
%      = 'x' : Sagittal cut : Y-Z plane
%      = 'y' : Coronal cut : X-Z plane
%      = 'z' : Transverse (Axial) cut : X-Y plane
% mode : 2D plot mode for X-Y 
%      = 0   : plot without transpose
%      = 1   : plot by transposing 2D-image matrix
% V    : Coordinates of points plotted with a slice (optional). 
%        The coordinate system of V is RAS. 
