function vb_check_sensor(brainfile, megfile)
% Plot cortex and sensor location.
% [Usage]
%    vb_check_sensor(brainfile, megfile);
% [Input]
%    brainfile : VBMEG brain file(.brain.mat)
%    megfile   : VBMEG MEG file(.meg.mat) or EEG file(.eeg.mat)
% [Output]
%    none
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Load sensor and sphere center position
%[pick,Qpick,Wsensor,Vcenter] = vb_load_sensor(megfile);
Measurement = vb_megfile_get_measurement(megfile);

% Load brain model
[V,F] = vb_load_cortex(brainfile, 'subj');

if ~isempty(F) 
    F     = F.F3;
end
[pick] = vb_load_channel(megfile);

% plot color
fclr = [0.72 0.59 0.45];

% plot brain
plot3(V(:,1), V(:,2), V(:,3), '.', 'color', fclr);
hold on; 

% plot sensor
plot3(pick(:,1),pick(:,2),pick(:,3),'bo');

title([Measurement ' sensor and brain model'])

view( [ -60  30] ); 
xlabel('X')
ylabel('Y')
zlabel('Z')
axis equal;
axis tight;
rotate3d;
