function [handles] = vb_check_mni_coregistration(brain_file)
% Check tool for MNI coordinate value corresponding to personal brain.
% Three thumbnail figures will be created(X,Y,Z direction) and
% MNI coordinate value corresponding to personal brain are plotted 
% on slices of ICBM152 MRI.
% [Usage]
%   vb_check_mni_coregistration(brain_file);
% [Input]
%    brain_file : Cortical model file(.brain.mat).
% [Output]
%       handles : figure handles.
% [Note]
%   currently, vb_plot_cross_section is not used in this function
%   because it takes much time to create figure.
% [History]
%   2013-01-24 rhayashi Initial version.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('brain_file', 'var')
    error('brain_file is required.');
end
if exist(brain_file, 'file') ~= 2
    error('Specified brain_file doesn''t exist.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
mni_template_file = vbmeg_inst.const.FILE_MNI_ICBM152_HDR;
handles = [];

% Load MNI coordinate value
[Vmni, F] = vb_load_cortex(brain_file, 'MNI');
if isempty(Vmni)
    vb_disp(...
    'Specified Cortical model file doesn''t contain MNI coordinate value', ...
    'WARNING');
     return;
end

% MNI template file
[B, Vdim, Vsize] = vb_load_analyze_to_right(mni_template_file);

% Convert MNI->SPM
Vmni = Vmni * 1e3; % m -> mm
Vspm = vb_mni_mm_to_spm_right(Vmni, mni_template_file);

% Convert SPM->RAS voxel 
Vmni2 = vb_spm_right_to_analyze_right(Vspm, Vdim, Vsize);

%
% --- Create Thumbnails
%

% Callback for click on thumbnail.
callback = ['parent = get(gcbo, ''Parent'');', ...
            'h_fig = figure;', ...
            'new_axes = copyobj(parent, h_fig);', ...
            'set(new_axes, ''Position'', [0,0,1,1]);', ...
            'h_line = findobj(get(new_axes, ''Children''), ''Type'',''line'');', ...
            'set(h_line, ''MarkerSize'', 5);', ...
            'set(get(new_axes, ''children''), ''ButtonDownFcn'', '''');'];

[x, y, z] = size(B);
% plot parameters
Msize   = 1;            % marker size
Mtype   = 'y-';         % marker type
dz      = 5;            % search radius for intersection triangle
xymode  = 0;

vb_disp('--- Plotting MNI coordinate value corresponding to a subject brain on MNI template image.');
vb_disp_nonl('Now creating thumbnail of X direction...');
% Xslice
h1 = figure; set(h1, 'Color', 'k', 'NumberTitle', 'off');
set(h1, 'Name', 'MNI value on MNI template image(YZ) - Click to open');
for k=1:1:x
    sh = vb_subaxis(ceil(x/15),15,k,'SV', 0, 'SH', 0, 'ML', 0, 'MT', 0, 'MR', 0, 'MB', 0); axis off; hold on;
    [strX, strY] = vb_plot_3d_image(B, k, 'x', 0);
%    vb_plot_cross_section(Vmni2, F.F3, k, 'x', dz, Msize, Mtype, xymode); 
    vb_plot_vertex(Vmni2, 'x', k, 5, 1, 'y.', 0);
    children = get(sh, 'Children');
    set(children, 'ButtonDownFcn', callback);
end
vb_disp('Done.');

% Yslice
vb_disp_nonl('Now creating thumbnail of Y direction...');
h2 = figure; set(h2, 'Color', 'k', 'NumberTitle', 'off');
set(h2, 'Name', 'MNI value  on MNI template image(XZ) - Click to open');
for k=1:1:y
    sh = vb_subaxis(ceil(y/15),15,k,'SV', 0, 'SH', 0, 'ML', 0, 'MT', 0, 'MR', 0, 'MB', 0); axis off; hold on;
    [strX, strY] = vb_plot_3d_image(B, k, 'y', 0);
    vb_plot_vertex(Vmni2, 'y', k, 5, 1, 'y.', 0);
    children = get(sh, 'Children');
    set(children, 'ButtonDownFcn', callback);
end
vb_disp('Done.');

% Zslice
vb_disp_nonl('Now creating thumbnail of Z direction...');
h3 = figure; set(h3, 'Color', 'k', 'NumberTitle', 'off');
set(h3, 'Name', 'MNI value on MNI template image(XY) - Click to open');
for k=1:1:z
    sh = vb_subaxis(ceil(z/15),15,k,'SV', 0, 'SH', 0, 'ML', 0, 'MT', 0, 'MR', 0, 'MB', 0); axis off; hold on;
    [strX, strY] = vb_plot_3d_image(B, k, 'z', 0);
    vb_plot_vertex(Vmni2, 'z', k, 5, 1, 'y.', 0);
    children = get(sh, 'Children');
    set(children, 'ButtonDownFcn', callback);
end
vb_disp('Done.');

handles = [h1; h2; h3];

