function	vb_check_inflate_model(proj_root,brain_parm)
% Plot brain model in 3D & on MRI slice for checking
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Brain file
%
if isempty(proj_root)
    brainfile   = [brain_parm.brain_file];
else
    brainfile   = [proj_root '/' brain_parm.brain_file];
end

%
%---- Cortex inflate image
%     

%---- Load vertex coordinate from brain file 
[V, F, xx, inf_C] = vb_load_cortex(brainfile,'Inflate');

% View angle
angle = [45 30; -45 30; -60 30; 60 30];

Nfig  = 4;
NY    = 2;
NX    = 2;

% Sulcus color
cscale = -0.4;
cmax   = 0.8;
color = repmat( (1 + inf_C*cscale) * cmax, [1 3]);

h = figure;
set(h, 'renderer', 'zbuffer');

subplot(NY,NX,1)
patch('Faces',F.F3L,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',color);
material dull;
axis equal
axis tight

view(angle(1,:));
title('Left brain')

subplot(NY,NX,2)
patch('Faces',F.F3R,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',color);
material dull;
axis equal
axis tight

view(angle(2,:));
title('Right brain')

subplot(NY,NX,3)
patch('Faces',F.F3,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',color);
material dull;
axis equal
axis tight

view(angle(3,:));
title('Both brain [Left angle]')

subplot(NY,NX,4)
patch('Faces',F.F3,'Vertices',V,'FaceColor','interp',...
	'EdgeColor','none','FaceVertexCData',color);
material dull;
axis equal
axis tight

view(angle(4,:));
title('Both brain [Right angle]')
