function Headinfo = vb_headinfo_set_vhead(headinfo, vhead)
% setter Headinfo.Vhead
% [usage]
%   Headinfo = vb_headinfo_set_vhead(headinfo, vhead)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%      vhead : <optional> value of Vhead (3D-coordinates of head)
%            :  if it is not specified or is empty, [] will be set
% [output]
%   Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('vhead', 'var')    vhead = []; end;
[Headinfo, vhead] = inner_check_arguments(headinfo, vhead);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.Vhead = vhead;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, vhead] = inner_check_arguments(headinfo, vhead)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
