function Headinfo = vb_headinfo_set_radius(headinfo, radius)
% setter Headinfo.R
% [usage]
%   Headinfo = vb_headinfo_set_radius(headinfo, radius)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%     radius : <optional> value of radius
%            :  if it is not specified or is empty, [] will be set
% [output]
%    Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('radius', 'var')   radius = []; end;
[Headinfo, radius] = inner_check_arguments(headinfo, radius);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.R = radius;

if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, radius] = inner_check_arguments(headinfo, radius)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
