function Headinfo = vb_headinfo_set_nvertex(headinfo, nvertex)
% setter Headinfo.Nvertex
% [usage]
%   Headinfo = vb_headinfo_set_nvertex(headinfo, nvertex)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%     nvertex : <optional> value of Nvertex
%            :  if it is not specified or is empty, [] will be set
% [output]
%    Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('nvertex', 'var')    nvertex = []; end;
[Headinfo, nvertex] = inner_check_arguments(headinfo, nvertex);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.Nvertex = nvertex;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, nvertex] = inner_check_arguments(headinfo, nvertex)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
