function Headinfo = vb_headinfo_set_npatch(headinfo, npatch)
% setter Headinfo.Npatch
% [usage]
%   Headinfo = vb_headinfo_set_npatch(headinfo, npatch)
% [input]
%   headinfo : <optional> <<struct>> Headinfo
%            :  if it is not specified or is empty, Headinfo will be created
%     npatch : <optional> value of Npatch
%            :  if it is not specified or is empty, [] will be set
% [output]
%    Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('npatch', 'var')    npatch = []; end;
[Headinfo, npatch] = inner_check_arguments(headinfo, npatch);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.Npatch = npatch;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, npatch] = inner_check_arguments(headinfo, npatch)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
