function layer_num = vb_headinfo_get_layer_num(head_info)
% return number of layer from <<struct>> Headinfo
% [usage]
%   layer_num = vb_head_get_layer_num(head_info)
% [input]
%   head_info : <required> <<struct>> Headinfo
% [output]
%   layer_num : number of layer
% [note]
%   criterion is the 'Npatch' field.
% [history]
%   2007-04-18 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('head_info', 'var') head_file = []; end;
[head_info] = inner_check_arguments(head_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isfield(head_info, 'Npatch') && size(head_info.Npatch, 1) > 1
  layer_num = size(head_info.Npatch, 1);
else
  layer_num = 1;
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [head_info] = inner_check_arguments(head_info)
if isempty(head_info)
  error('head_info is a required parameter');
end
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
