function	[pick, R] = vb_calc_consistent_eeg_radius(V,pick,Rrate)
% check EEG sensor radius
% [pick, R] = vb_calc_consistent_eeg_radius(V.pick,Rrate)
% 
% Check (EEG radius)*Rrate(1) > (dipole radius)
% if not satisfied, R & pick are adjusted to satisfy this constraint
%
% pick  : EEG sensor position
% V     : dipole position
% Rrate : Relative radius of sphere from innermost to outermost
% R     : Radius of sphere from innermost to outermost
% 
% 2007/6/15 Masa-aki Sato
% 2007-12-6  M. Sato 
%   Rmargin is changed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Rrate = [ 0.87  0.92   1.0 ]

Rmargin = 1.05;

% Check Rrate is increasing order
Rdif = diff(Rrate);

if any(Rdif < 0),
	error('Relative radius is not increasing order')
end

Rrate = Rrate/Rrate(end);

% Max of dipole radius
Rmax  = sqrt(max(sum(V.^2,2)));

% Rmax calculated from dipole radius
Rmax  = Rmax*Rmargin/Rrate(1);

% Mean of EEG sensor radius
Rpick = sqrt(mean(sum(pick.^2,2)));

% Check (EEG radius) >= Rmax
if Rpick < Rmax, Rpick = Rmax; end;

R = Rrate * Rpick;

% Radius of pick is set to Rpick
Reeg = sqrt(sum(pick.^2, 2));
pick = Rpick * pick./Reeg(:,ones(1,3));	% EEG sensor ( M x 3 )

