function	[Peeg] = vb_bem_inverse_eeg(D,IXeeg,BEM)
% transform matrix to map dipole potencial to EEG potencial
%  [Peeg] = vb_bem_inverse_eeg(D,IXeeg,BEM)
% D     : Solid angle matrix for boundary surfaces [Nvertex x Nvertex]
% IXeeg : Vertex index for EEG sensor [Nsensor x 1]
% BEM.sigma 	= conductivity for each layer, ΰƳΨ 
%               = [sigma(1), ..., sigma(Nsurf), 0]
% BEM.Nvertex   = # of vertex for each layer, ƶ̤ĺ
%               = [ start_id(1)     end_id(1)     ; 
%                             ...                 ;
%                   start_id(Nsurf) end_id(Nsurf) ]
%               = [ϥǥå, λǥå]
%
% Peeg : transform matrix to map dipole potencial to EEG potencial
%        [Nsensor x Nvertex]
% Peeg : ж˻ҥݥƥ󥷥뤫EEG 󥵥ݥƥ󥷥ؤѴ
%
% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified
% 2007-12-16  M. Sato Input & output are changed
% 2008-10-8  M. Sato input is changed from 'Keeg' to 'BEM'
% 2009-10-8  M. Sato correct constant factor : 1/sigma(1)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%  ѿμ
NS = length(IXeeg);  % # of sensor
NV = size(D,1);      % # of vertex

% ĺEEG󥵤ؤμͱƹ
Proj = zeros(NS,NV);

for n=1:NS
	Proj(n,IXeeg(n)) = 1/(4*pi);
end
	
% Peeg : ж˻ҥݥƥ󥷥 P0 EEG 󥵥ݥƥ󥷥ؤѴ
% P    : ᤿̾Υݥƥ󥷥
% P0   : ̾ж˻ҥݥƥ󥷥
% D    : Ωγѷ
% Keeg : ¿إǥݥƥ󥷥(EEG) 
% P(EEG) : EEG 󥵥ݥƥ󥷥
% Proj   : EEG 󥵤ؤμͱƹ
%
%  D * P = Keeg .* P0 
%      P = inv(D) * (Keeg .* P0)
% P(EEG) = Proj * P = (Proj * inv(D)) * (Keeg' .* P0)
%        = Peeg * P0
%  Peeg  = (Proj * inv(D)) .* Keeg
% 

Peeg = Proj/D;

% ¿إǥξ硧ƳΨˤ
if exist('BEM','var'),
	if isempty(BEM), return; end;
	
	% ¿إǥξ硧ƳΨˤ
	
	Nvertex = BEM.Nvertex;		% ƶ̤ĺ
	Nsurf	= size(Nvertex,1);	% ̤ο
	sigma	= BEM.sigma  ;		% ΰƳΨ
	
	if length(sigma)== Nsurf, sigma = [sigma(:); 0]; end;
	
	Keeg    = ones(1,NV);		% EEG ݥƥ󥷥 ׻
	
	% ̤˴ؤ롼
	for i=1:Nsurf,
		ix = Nvertex(i,1):Nvertex(i,2);
		
		% ݥƥ󥷥뷸
		Keeg(ix) = 1/(sigma(i) + sigma(i+1));
		%Keeg(ix) = sigma(1)/(sigma(i) + sigma(i+1));
		%Keeg(ix) = 2*sigma(2)/(sigma(i) + sigma(i+1));
	end
	
	Peeg = vb_repmultiply(Peeg , Keeg);
end;

