function [V,F,indx,Ninfo] = vb_create_curry_patch(FV)
% Calculate patch index from Curry vertex format
%  [V,F,indx] = vb_create_curry_patch(FV)
%  [V,F,indx,Ninfo] = vb_create_curry_patch(FV)
% --- Input
% FV : curry surface vertex: N  x 3 
% --- Output
% V  : vertex coordinate   : NV x 3 
% F  : surface patch index : NF x 3, NF = N/3
% indx : selected index for 'V'
%        V = FV(indx,:) 
% Ninfo : Debug info
%
% --- Curry coordinate variable
% FV : 3 vertex coordinate in i-th triangle 
% FV(i+1,:)
% FV(i+2,:)
% FV(i+3,:)
% i = ix * 3, 
% ---
% To speed up, slicewise search is done
%
% 2006-10-26 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fprintf('--- Create patch data ');

[V,indx] = unique(FV,'rows');
NF = size(FV,1)/3;
NV = size(V,1);
F = zeros(NF,3);

%h = waitbar(0,'Create patch data');

% Slice definition
Nstep = 100;
Zmax  = max(V(:,3));
Zmin  = min(V(:,3));
Zwid  = (Zmax-Zmin)/1000;
Zmax  = Zmax + Zwid;
Zmin  = Zmin - Zwid;
Zstep = max( (Zmax-Zmin)/Nstep , eps);
Zlist = Zmin:Zstep:Zmax;
Nstep = length(Zlist) - 1;

NVcnt  = 0;
NFcnt  = 0;
NFcnt1 = 0;

% Loop for slices in z-direction
for n=1:Nstep,
	% Find vertex points in this slice
	ixV  = find(  V(:,3) >= Zlist(n) &  V(:,3) < Zlist(n+1));
	ixF  = find( FV(:,3) >= Zlist(n) & FV(:,3) < Zlist(n+1));
	
	NVz  = length(ixV);	% # of vertex  'V' in this slice
	NFz  = length(ixF);	% # of vertex 'FV' in this slice
	NVcnt = NVcnt + NVz;
	NFcnt = NFcnt + NFz;
	
	FVz  = FV(ixF,:);	% 'FV' in this slice

	for k=1:NVz,
		i  = ixV(k);
		Vz = V(i,:);	% 'V' in this slice
		
		% Distance between 'FVz' and 'Vz'
        dd	= abs(FVz(:,1) - Vz(1)) ...
            + abs(FVz(:,2) - Vz(2)) ...
            + abs(FVz(:,3) - Vz(3));
            
		% Find ( FV(ix) = V(i) )
		jj  = find(dd < eps);
		NFcnt1 = NFcnt1 + length(jj);
		
	    ix  = ixF(jj);
		ix0 = ix-1;
		
		% Translate to patch index
		% FV(ix0 + 1,:) = V(i,:)
		% ix0 = (ix1-1)*3 + (ix2-1)
		%     : 'ix1'-th triangle 
		%     & 'ix2'-th vertex in 3 triangle vertex
		% F(ix1,ix2) = i

		ix1 = floor(ix0/3)+1;
		ix2 = mod(ix0,3)+1;
		
		for j = 1:length(ix1)
		  F(ix1(j),ix2(j)) = i;
		end
	end
	%waitbar(n/Nstep);
end
%
%close(h);
%drawnow;

Ninfo.NVcnt  = NVcnt;
Ninfo.NFcnt  = NFcnt;
Ninfo.NFcnt1 = NFcnt1;

return
