function	[omega1,omega2,omega3]=...
               vb_solid_other(x0,x1,x2,x3,s,Sinv)
% solid angle calculation by Gararkin method
% 3 solid angles from 3 points in one triangle are calculated
%  [omega1,omega2,omega3] = vb_solid_other(x0,x1,x2,x3,s,Sinv)
% 鸫¾λ̤νŤդΩγѷ׻
%
% x0         : (໰̤ΰĤ)
% (x1,x2,x3) : оݻ̤3Ĥĺ
% s          : оݻˡ
% Sinv       : 1/оݻ̤
%
% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

MIN_VAL = realmin*100;

y1 = x1-x0;
y2 = x2-x0;
y3 = x3-x0;

w1 = y2-y3;
w2 = y3-y1;
w3 = y1-y2;

z1 = vb_cross2(y2,y3);
z2 = vb_cross2(y3,y1);
z3 = vb_cross2(y1,y2);

d  = sum(z1.*y1,2);

W1 = sqrt(sum(w1.^2,2));
W2 = sqrt(sum(w2.^2,2));
W3 = sqrt(sum(w3.^2,2));

Y1 = sqrt(sum(y1.^2,2));
Y2 = sqrt(sum(y2.^2,2));
Y3 = sqrt(sum(y3.^2,2));

YA = Y1.*Y2.*Y3;
YB = Y1.*sum(y2.*y3,2)+Y2.*sum(y3.*y1,2)+Y3.*sum(y1.*y2,2);
omega0 = 2*atan(d./(YA+YB));
%
% gamma1
%
tmp1 = W3.*Y1-sum(w3.*y1,2);
tmp2 = W3.*Y2-sum(w3.*y2,2);

%gamma1 = log(tmp2./tmp1)./W3;
ix1 = find( tmp1 >  MIN_VAL & tmp2 >  MIN_VAL);
ix2 = find( tmp1 <= MIN_VAL | tmp2 <= MIN_VAL);
gamma1 = zeros(length(tmp1),1);
gamma1(ix1) = log(tmp2(ix1)./tmp1(ix1))./W3(ix1);
gamma1(ix2) = log(Y2(ix2)./Y1(ix2));

%
% gamma2
%
tmp1 = W1.*Y2-sum(w1.*y2,2);
tmp2 = W1.*Y3-sum(w1.*y3,2);
%gamma2 = log(tmp2./tmp1)./W1;
ix1 = find( tmp1 >  MIN_VAL & tmp2 >  MIN_VAL);
ix2 = find( tmp1 <= MIN_VAL | tmp2 <= MIN_VAL);
gamma2 = zeros(length(tmp1),1);
gamma2(ix1) = log(tmp2(ix1)./tmp1(ix1))./W1(ix1);
gamma2(ix2) = log(Y3(ix2)./Y2(ix2));

%
% gamma3
%
tmp1 = W2.*Y3-sum(w2.*y3,2);
tmp2 = W2.*Y1-sum(w2.*y1,2);
%gamma3 = log(tmp2./tmp1)./W2;
ix1 = find( tmp1 >  MIN_VAL & tmp2 >  MIN_VAL);
ix2 = find( tmp1 <= MIN_VAL | tmp2 <= MIN_VAL);
gamma3 = zeros(length(tmp1),1);
gamma3(ix1) = log(tmp2(ix1)./tmp1(ix1))./W2(ix1);
gamma3(ix2) = log(Y1(ix2)./Y3(ix2));

omega4 = gamma2(:,ones(1,3)).*w1 ...
       + gamma3(:,ones(1,3)).*w2 ...
       + gamma1(:,ones(1,3)).*w3;

omega1 = Sinv.*( sum(s.*z1,2).*omega0 ...
		      + d.*(sum(w1.*omega4,2)) );
omega2 = Sinv.*( sum(s.*z2,2).*omega0 ...
		      + d.*(sum(w2.*omega4,2)) );
omega3 = Sinv.*( sum(s.*z3,2) .*omega0 ...
			  + d.*(sum(w3.*omega4,2)) );
