function	BS = vb_sensor_mag(Vs,Fs,s0,X,Q)
% ѷ (x1, x2, x3) ñή  X ˺뼧 Q ͱ
% Vs : ̤κɸ
% Fs : ĺǥå
% s0 : ̤γˡ
% X  : 󥵡ɸ             (Npick,  3)
% Q  : δ¬               (Npick,  3)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified

%  ѿμ
NS = size(X,1);		% 󥵡
NV = size(Vs,1);	% ĺ
NF = size(Fs,1);	% 

BS = zeros(NV,NS);  % ĺñή뼧

% ̤ĺtriangle vertex
x1 = Vs(Fs(:,1),:);
x2 = Vs(Fs(:,2),:);
x3 = Vs(Fs(:,3),:);

%%% ĺñή  ¬ ˺뼧׻ %%%

for i=1:NS,
  % i-ܤδ¬
  G0 = Q(i,:)';
  XP = X(i,:);
  XX = XP(ones(NF,1),:);
	
  % ѷ (x1, x2, x3) ñή  XP ˺뼧 G0 ͱ
  
  % 󥵰֤Ф뻰ĺа
  y1 = x1 - XX;
  y2 = x2 - XX;
  y3 = x3 - XX;
  
  % y1*((y2-y1)x(y3-y1)) ѷγˡˤʤ褦 
  % y2  y3 ؤ
  ix = find( sum(vb_cross2(y2-y1,y3-y1).*y1, 2) < 0);
  tmp = y2(ix,:);
  y2(ix,:) = y3(ix,:);
  y3(ix,:) = tmp;
  Fn = Fs; 
  Ftemp    = Fn(ix,2);
  Fn(ix,2) = Fn(ix,3);
  Fn(ix,3) = Ftemp;

  % ĺа֥٥ȥΥΥ
  yy1 = sqrt(sum(y1.^2 ,2));
  yy2 = sqrt(sum(y2.^2 ,2));
  yy3 = sqrt(sum(y3.^2 ,2));
  
  % д٥ȥ
  z1 = vb_cross2(y2,y3);
  z2 = vb_cross2(y3,y1);
  z3 = vb_cross2(y1,y2);
  
  d  = sum(z1.*y1,2);
  s  = z1+z2+z3;
  ss = sqrt(sum(s.^2,2));
  n  = s./ss(:,ones(1,3));

  % ѷ
  w1 = y2 - y3;
  w2 = y3 - y1;
  w3 = y1 - y2;

  % դΥΥ
  ww1 = sqrt(sum(w1.^2 ,2));
  ww2 = sqrt(sum(w2.^2 ,2));
  ww3 = sqrt(sum(w3.^2 ,2));

  wy1 = ( ww3.*yy2 - sum(w3.*y2, 2) )./( ww3.*yy1 - sum(w3.*y1, 2) );
  wy2 = ( ww1.*yy3 - sum(w1.*y3, 2) )./( ww1.*yy2 - sum(w1.*y2, 2) );
  wy3 = ( ww2.*yy1 - sum(w2.*y1, 2) )./( ww2.*yy3 - sum(w2.*y3, 2) );

  g1 = log(wy1)./ww3;
  g2 = log(wy2)./ww1;
  g3 = log(wy3)./ww2;
	
  cc = sum(y1.*n,2);
  c = cc(:,ones(1,3)).*n;
  c1 = y1-c;
  c2 = y2-c;
  c3 = y3-c;

  % ̤Ωγ
  omega = 2*atan(d./((yy1.*yy2.*yy3) ...
                    + yy1.*sum(y2.*y3,2) ...
                    + yy2.*sum(y3.*y1,2) ...
                    + yy3.*sum(y1.*y2,2)));
  
  g = sign(sum(s0.*n,2)) ...
              .*(g1.*sum(n.*vb_cross2(c1,c2),2) ...
			   + g2.*sum(n.*vb_cross2(c2,c3),2) ...
			   + g3.*sum(n.*vb_cross2(c3,c1),2) ...
			   - sum(n.*c,2).*omega)./ss;

  % ĺδͿ
  omegaF1 = w1.*g(:,ones(1,3));
  omegaF2 = w2.*g(:,ones(1,3));
  omegaF3 = w3.*g(:,ones(1,3));
  
  for j = 1:NF
    BS(Fn(j,1),i) = BS(Fn(j,1),i)+omegaF1(j,:)*G0;
    BS(Fn(j,2),i) = BS(Fn(j,2),i)+omegaF2(j,:)*G0;
    BS(Fn(j,3),i) = BS(Fn(j,3),i)+omegaF3(j,:)*G0;
  end
end;

% BS(i,k) :  V(k,:) ñή  X(i,:) ˺뼧 
%         : (Nsensor x Nvertex)
BS = BS';
