function	B0 = vb_dipole_mag(J0,x0,X,Q)
% Dipole magnetic field 
%  B0 = vb_dipole_mag(J0,x0,X,Q)
% ж˻Ҽ׻
% x0 ж˻ J0  ¬ X ˺뼧 Q ͱ
% B0 = Q*(JJ x Xd)/|Xd|^3 , Xd = X - x0
%
% 2004-02-06 Taku Yoshioka
% 2004-12-26 M. Sato modified
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
  
Xd = [X(:,1)-x0(1), X(:,2)-x0(2), X(:,3)-x0(3)];
dd = sum( Xd.^2, 2 );
Rx = sqrt(dd).*dd;
	
% ѷ׻ JJ x Xd
JB = [J0(2).*Xd(:,3) - J0(3).*Xd(:,2), ...
      J0(3).*Xd(:,1) - J0(1).*Xd(:,3), ...
      J0(1).*Xd(:,2) - J0(2).*Xd(:,1)];
	
B0 = sum( JB.*Q, 2 )./Rx;
