function vb_job_inflate(proj_root,brain_parm)
% Make inflated cortical surface model.
% (VBMEG public function)
%
% [syntax]
% vb_job_inflate(proj_root,brain_parm)
%
% [input]
% proj_root : <<string>> VBMEG project root directory. 
% brain_parm: <<struct>> Parameters for creating inflated model
% --- fields of brain_parm
%  brain_file  : <<string>> Filename of .brain.mat file
%  area_file   : <<string>> Filename of .area.mat file
%
%  (parameters for BrainVoyager inflated model)
%  BV_left_infl_file : <<string>> Brain-Voyager left  inflate file
%  BV_right_infl_file: <<string>> Brain-Voyager right inflate file
%
%  (parameters for FreeSurfer inflated model)
%  FS_left_infl_file : <<string>> FreeSurfer left inflate file
%  FS_right_infl_file: <<string>> FreeSurfer right inflate file
%  FS_left_curv_file : <<string>> FreeSurfer left curvature file
%  FS_right_curv_file: <<string>> FreeSurfer right curvature file
% ---
%
% [output]
% VBMEG cortical surface model file (.brain.mat) is updated with
% variables of inflated model. 
%
% The following variables are stored in .brain.mat file: 
% Vinflate: <<matrix>> Inflate model vertex
% inf_C   : <<vector>> Color corresponding to curvature
%
% [history]
% 2010-05-28 Taku Yoshioka
%  Minor change (verbose level support)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

proj_root = vb_rm_trailing_slash(proj_root);

% Do not modify following lines
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Make inflate and flat models
%

% Output file path
if isempty(proj_root)
	brain_file = [brain_parm.brain_file];
	area_file  = [brain_parm.area_file ];
else
	brain_file = [proj_root filesep brain_parm.brain_file];
	area_file  = [proj_root filesep brain_parm.area_file ];
end

%
% Make inflate and flat models
%
[Vinflate,inf_C] = vb_make_inflate_data(proj_root, brain_parm);

%
% --- save the inflate model
%

vb_disp(['Save brain model ']);
vb_disp(sprintf('     file = %s', [brain_file]));

vb_save([brain_file], 'Vinflate','inf_C');

% Plot Inflate model
vb_check_inflate_model(proj_root,brain_parm);

area_key = 'reduced_cortex';
Area  = vb_get_area(area_file, area_key);

if ~isempty(Area),
  Vindx = Area.Iextract;
	
  Vinflate = Vinflate(Vindx,:);
  inf_C    = inf_C(Vindx,:);
	
  brain_file = vb_change_file_basename(brain_file, '_reduce');
  vb_disp(['Save reduced brain inflate model ']);
  vb_disp(sprintf('     file = %s', [brain_file]));

  vb_save([brain_file], 'Vinflate','inf_C');

  % Plot Inflate model
  %brain_parm.brain_file = brain_file;
  vb_check_inflate_model(proj_root,brain_parm);
else
%  vb_disp('There is no reduced brain model.');
end
