function job_view_lf_update_cortexpattern(inst_id)
% Update brain activity map
%
% [syntax]
% job_view_lf_update_cortexpattern(inst_id)
%
% [history]
% 2009-01-27 Taku Yoshioka
% 2010-08-26 Taku Yoshioka
%  Replace function (vb_plot_cortex->vb_plot_cortex)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.viewlf{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.viewlf{inst_id}.h_fig; 
h_cortex = vbmeg_inst.viewlf{inst_id}.h_cortex;
plot_parm = vbmeg_inst.viewlf{inst_id}.plot_parm;
Jmin_plot = vbmeg_inst.viewlf{inst_id}.Jmin_plot;
Jmax_plot = vbmeg_inst.viewlf{inst_id}.Jmax_plot;
ix_selected_vertex = vbmeg_inst.viewlf{inst_id}.ix_selected_vertex;
cb1 = vbmeg_inst.viewlf{inst_id}.cb1; % 'left_brain'
cb2 = vbmeg_inst.viewlf{inst_id}.cb2; % 'right_brain'
cb3 = vbmeg_inst.viewlf{inst_id}.cb3; % 'fix_cortex_colorbar'
rb1 = vbmeg_inst.viewlf{inst_id}.rb1; % 'model_type_original_rb'
basis_org = vbmeg_inst.viewlf{inst_id}.basis_org_smoothed;
F = vbmeg_inst.viewlf{inst_id}.F;
%h_cbar_cortex = vbmeg_inst.viewlf{inst_id}.h_cbar_cortex;
%nextDD = vbmeg_inst.viewlf{inst_id}.nextDD;
%nextIX = vbmeg_inst.viewlf{inst_id}.nextIX;

%
% Preparation for cortical surface plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'Pointer','arrow');

% Original/Inflated model
if get(rb1,'Value')==1,
  V = vbmeg_inst.viewlf{inst_id}.V;
  inf_C = [];
else
  V = vbmeg_inst.viewlf{inst_id}.Vinf;
  inf_C = vbmeg_inst.viewlf{inst_id}.inf_C;
end

% Leadfield map (norm)
if isempty(basis_org), 
  isact = 0;
  J = [];
else
  isact = 1;
  J = sum(sqrt(basis_org.^2),1)';
end

% Scaling
if get(cb3,'Value') ~= get(cb3,'Max'), 
  Jmax_plot = max(abs(J));
  Jmin_plot = -1*Jmax_plot;
  vbmeg_inst.viewlf{inst_id}.Jmax_plot = Jmax_plot;
  vbmeg_inst.viewlf{inst_id}.Jmin_plot = Jmin_plot;
end

% Display parameters
LRflag = [];
if get(cb1,'Value')==get(cb1,'Max'), LRflag = 'L'; end
if get(cb2,'Value')==get(cb2,'Max'), LRflag = [LRflag 'R']; end;
if isempty(LRflag), 
  set(cb1,'Value',get(cb1,'Max')); 
  LRflag = 'L';
end
plot_parm.LRflag = LRflag; 
plot_parm.isact = isact;

%
% Plot brain activities superimposed on the cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'CurrentAxes',h_cortex);
cla; 
%vb_plot_cortex(plot_parm,V,F,inf_C,J,Jmin_plot,Jmax_plot,[]);
vb_plot_cortex(plot_parm,V,F,inf_C,J,Jmin_plot,Jmax_plot);
axis off;
axis tight;
axis equal;
if ~isempty(J), 
  colormap(jet);
  %reset(h_cbar_cortex);
  %colorbar(h_cbar_cortex);
  colorbar;
end

% Plot indicator for selected Vertex
plot3(V(ix_selected_vertex,1),V(ix_selected_vertex,2),...
      V(ix_selected_vertex,3),'gx','MarkerSize',15,'LineWidth',3);

% Update standard brain coordinate
%job_plot_cmap_update_talcoord(inst_id);

set(h_fig,'Pointer','arrow');

job_view_lf_push_rotate_button(inst_id);
%job_view_lf_change_colorbar(inst_id);
