function job_view_lf_change_filter_radius(inst_id)
% Change filter radius
% 
% --- Syntax
% function job_view_lf_change_filter_radius(inst_id)
%
% --- History
% 2009-01-27 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.viewlf{inst_id}.h_fig;
brainfile = vbmeg_inst.viewlf{inst_id}.brainfile;
ed3 = vbmeg_inst.viewlf{inst_id}.ed3; % Filter radius
basis_org = vbmeg_inst.viewlf{inst_id}.basis_org;

if isempty(brainfile), return; end;

%
% Filter calculation
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Rfilt = str2num(get(ed3,'String'));
if Rfilt<0, Rfilt = 0; end
ix = 1:size(basis_org,2);

set(h_fig,'Pointer','watch');
W = vb_spatial_gauss_filter(brainfile,Rfilt,Rfilt*2,ix);
vbmeg_inst.viewlf{inst_id}.basis_org_smoothed = basis_org*W;
set(h_fig,'Pointer','arrow');

%
% Update graphics
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_view_lf_update_cortexpattern(inst_id);
job_view_lf_update_sensorpattern(inst_id);
