function job_view_cortex_init( varargin )
% saib_init( [ <.brain.mat file>, ...
%              [ '--act', <.act.mat file> ], ...
%              [ '--area', <.area.mat file> ] ] )
%
% Ǿǥɽ롼 ưץ
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% GUIκ
job_view_cortex_figure( 'create' );
H = get( gcf, 'UserData' );
set( H.fig, 'Pointer', 'watch' );

% ǡ¤κ
DATA = job_view_cortex_init_data;
set( H.braindata, 'UserData', DATA.brain );
set( H.actdata, 'UserData', DATA.act );
set( H.areadata, 'UserData', DATA.area );
set( H.selectdata, 'UserData', DATA.selection );
set( H.paramdata, 'UserData', DATA.param );

if nargin > 0 & ~isempty( varargin{1} );
  err = job_view_cortex_file( 'load', 'brain', varargin{1} );
  
  if ~err
    job_view_cortex_aftereffect( 'file load brain' );
    
    i = 1;
    while nargin > i
      i = i + 1;
      switch varargin{i}

       case '--act'
	i = i + 1;
	if nargin < i
	  disp( 'sabo_init: option ''--act'' need an argument(filename)' );
	else
	  err = job_view_cortex_file( 'load', 'act', varargin{i} );
	end
	if ~err
	  job_view_cortex_aftereffect( 'file load act' );
	end

       case '--area'
	i = i + 1;
	if nargin < i
	  disp( 'sabo_init: option ''--area'' need an argument(filename)' );
	else
	  err = job_view_cortex_file( 'load', 'area', varargin{i} );
	end
	if ~err
	  job_view_cortex_aftereffect( 'file load area' );
	end

       otherwise
	disp( [ 'job_view_cortex_init: option ' varargin{i} ' unknown' ] );

      end % switch
      
    end % while
    
    job_view_cortex_plot( 'brain' );

  end % if ~err
      
end % if nargin > 0

set( H.fig, 'Pointer', 'arrow' );



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% ǡؿ
%%
function DATA = job_view_cortex_init_data

DATA.brain.filename = '';
DATA.brain.V = [];
DATA.brain.F = [];
DATA.brain.nextVi = {};
DATA.brain.nextVd = {};
DATA.brain.Va = [];
DATA.brain.Vinflate = [];
DATA.brain.S = [];

DATA.act.filename = '';
DATA.act.source = [];
DATA.act.candidate = [];
DATA.act.plotted = [];

DATA.area.filename = '';
DATA.area.source = [];
DATA.area.candidate = [];
DATA.area.plotted = [];
DATA.area.masking = [];

DATA.selection.Vi = [];
DATA.selection.history = [];

DATA.param = job_view_cortex_INIT_PARAMETER;
