function job_plot_meg_update_spatialpattern(inst_id)
% Update contour map of MEG signal
%
% --- Syntax
% function job_plot_meg_update_spatialpattern(inst_id)
%
% --- History
% 2008-09-02 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotmeg{inst_id}.bexp), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.plotmeg{inst_id}.h_fig; 
h_space = vbmeg_inst.plotmeg{inst_id}.h_space;
n_trial = vbmeg_inst.plotmeg{inst_id}.n_trial;
t = vbmeg_inst.plotmeg{inst_id}.t;
pick = vbmeg_inst.plotmeg{inst_id}.pick;
MEGinfo = vbmeg_inst.plotmeg{inst_id}.MEGinfo;
cb1 = vbmeg_inst.plotmeg{inst_id}.cb1;
cc_max = max(max(abs(vbmeg_inst.plotmeg{inst_id}.bexp(:,:,n_trial))));
pretrigger = vb_meginfo_get_pre_trigger(MEGinfo);
if isempty(pretrigger), pretrigger = 0; end
tt = round((t(1):t(2))*MEGinfo.SampleFreq/1000+pretrigger+1);
bexp0 = mean(vbmeg_inst.plotmeg{inst_id}.bexp(:,tt,n_trial),2)';
ed5 = vbmeg_inst.plotmeg{inst_id}.ed5;

%
% Select sensor
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sensor_type = vbmeg_inst.plotmeg{inst_id}.sensor_type;

if sensor_type~=-1, 
  ix = find(MEGinfo.ChannelInfo.Type==sensor_type);
  bexp0 = bexp0(ix);
  pick = pick(ix,:);
end

%
% Draw contour map
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Colormap
if get(cb1,'Value')==get(cb1,'Max')
  c = str2num(get(ed5,'String'));
  if c<0, c = abs(c); end
  clim = [-c c];
  %clim = 0.7*[-cc_max cc_max];
else
  c = max(abs(bexp0));
  set(ed5,'String',num2str(ceil(c)));
  clim = [-c c];
  %clim = [-1*max(abs(bexp0)) max(abs(bexp0))];
end

set(h_fig,'CurrentAxes',h_space);

% Plot sensor
vb_plot_sensor_2d(pick(:,1:3),bexp0,clim);
vb_plot_sensor_2d_head_plot_add(gca);

% Plot selected sensor
job_plot_meg_choose_plot_sensor(inst_id, 'plot'); 

set(h_space, 'XtickLabel', []);
set(h_space, 'YtickLabel', []);
set(h_space, 'TickLength', [0 0]);
set(h_space, 'Color', 'none');
set(h_space, 'XColor', get(h_fig, 'Color'));
set(h_space, 'YColor', get(h_fig, 'Color'));

axis equal;
axis tight;
colormap(jet);

colorbar;
cb_str = ['job_plot_meg_choose_plot_sensor(', num2str(inst_id), ',1)'];

set(get(h_space, 'children'), 'HitTest', 'off');
set(h_space, 'HitTest', 'on');
set(h_space, 'ButtonDownFcn', cb_str);

