function job_plot_meg_save_waveform(inst_id)
% Save waveform data. Invoked by job_plot_meg.
%
% [syntax]
%  job_plot_meg_save_waveform(inst_id);
%
% [history]
% 2015/12/11 rhayashi Initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
if isempty(vbmeg_inst.plotmeg{inst_id}.megfile);
    warning('Data file not specified.');
    return;
end

switch(vbmeg_inst.plotmeg{inst_id}.sensor_type)
    case 1
        sensor_type = 'Magnetometer';
    case 2
        sensor_type = 'Axial gradiometer';
    case 3
        sensor_type = 'Planar gradiometer';
    case -1
        sensor_type = 'Mix';
    otherwise
        error('Unknown sensor type was detected.');
end

sensor_name    = vbmeg_inst.plotmeg{inst_id}.selected_sensor_name;
sensor_data    = vbmeg_inst.plotmeg{inst_id}.plotting_timecourse;
sensor_average = mean(vbmeg_inst.plotmeg{inst_id}.plotting_timecourse, 1);

% Save dialog
[s_dir, s_file] = vb_file_select({'.mat'},'Input save filename',true);
if ~isempty(s_file)
    save_file     = fullfile(s_dir, filesep, s_file{1});
    save_image_file = strrep(save_file, '.mat', '.png');

    % Confirm overwrite or not
    if exist(save_file, 'file') == 2
        res = questdlg('File already exists. overwrite?', 'Confirm', 'Yes', 'No', 'Yes');
        if strcmpi(res, 'No')
            return;
        end
    end
    
    % Save waveform and image file
    fig = vbmeg_inst.plotmeg{inst_id}.h_fig;
    oldscreenunits = get(fig,'Units');
    oldpaperunits  = get(fig,'PaperUnits');
    oldpaperpos    = get(fig,'PaperPosition');

    set(fig,'Units','pixels');
    scrpos = get(fig,'Position');
    newpos = scrpos/100;
    set(fig,'PaperUnits','inches','PaperPosition',newpos)

    vb_fsave(save_file, 'sensor_name', 'sensor_type', 'sensor_data', 'sensor_average');
    print('-dpng', save_image_file, '-r100');
    disp(['File saved       : ' save_file]);
    disp(['image file saved : ' save_image_file]);
    set(fig, 'Units', oldscreenunits);
    
    msgbox('File saved.', 'Notice');
end
