function job_plot_cmap_update_timecourse(inst_id)
% Update temporal pattern of brain activity
% 
% --- Syntax
% function job_plot_cmap_update_timecourse(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-08-28 Taku Yoshioka
% 2008-10-22 Taku Yoshioka
%   Faster display of timecourse. 
% 2008-11-07 Taku Yoshioka
%   Bug fix.
% 2008-03-08 rhayashi
%   not to occure Divide by zero.
% 2010-12-11 taku-y
%  [major] Time-frequency data supported. 
% 2011-01-27 taku-y
%  [debug] Time-frequency window selection for 'linear' scaling. 
% 2011-04-01 taku-y
%  [minor] Colorbar fnc argument changed depending on MATLAB version.
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced to "ix_trial"
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end
const = vb_define_verbose;
VERBOSE_LEVEL_DEBUG = const.VERBOSE_LEVEL_DEBUG;

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig     = vbmeg_inst.plotcmap{inst_id}.h_fig; 
h_time    = vbmeg_inst.plotcmap{inst_id}.h_time;
h_cbar_tf = vbmeg_inst.plotcmap{inst_id}.h_cbar_tf;
ix_trial  = vbmeg_inst.plotcmap{inst_id}.ix_trial;
Jinfo     = vbmeg_inst.plotcmap{inst_id}.Jinfo;
TFinfo    = vbmeg_inst.plotcmap{inst_id}.TFinfo;
TFmax     = vbmeg_inst.plotcmap{inst_id}.TFmax;
TFmin     = vbmeg_inst.plotcmap{inst_id}.TFmin;
toi       = vbmeg_inst.plotcmap{inst_id}.toi;
foi       = vbmeg_inst.plotcmap{inst_id}.foi;
ix_peak   = vbmeg_inst.plotcmap{inst_id}.ix_peak;
J_hold    = vbmeg_inst.plotcmap{inst_id}.J_hold; 
cb4       = vbmeg_inst.plotcmap{inst_id}.cb4;
ed10      = vbmeg_inst.plotcmap{inst_id}.ed10; % Jmax_tf_plot_edit


set(h_fig,'Pointer','watch');
drawnow;

if ~isempty(Jinfo), 
  Tmsec = Jinfo.Tmsec;
elseif ~isempty(TFinfo), 
  Tmsec = TFinfo.Tmsec;
else
  return;
end

% Vertex check
I = size(vbmeg_inst.plotcmap{inst_id}.V,1); 
ix_peak = ceil(ix_peak);
if ix_peak<1, ix_peak = 1; end
if ix_peak>I, ix_peak = I; end 
vbmeg_inst.plotcmap{inst_id}.ix_peak = ix_peak;

% Time window range check
if toi(1)<min(Tmsec), toi(1)=min(Tmsec); end
if toi(1)>max(Tmsec), toi(1)=max(Tmsec); end
if toi(2)<min(Tmsec), toi(2)=min(Tmsec); end
if toi(2)>max(Tmsec), toi(2)=max(Tmsec); end
if toi(1)>toi(2), toi=toi(2:-1:1); end
vbmeg_inst.plotcmap{inst_id}.toi = toi;

% Frequency window range check
if ~isempty(TFinfo),
  if foi(1)<min(TFinfo.freq), foi(1)=min(TFinfo.freq); end
  if foi(1)>max(TFinfo.freq), foi(1)=max(TFinfo.freq); end
  if foi(2)<min(TFinfo.freq), foi(2)=min(TFinfo.freq); end
  if foi(2)>max(TFinfo.freq), foi(2)=max(TFinfo.freq); end
  if foi(1)>foi(2), foi=foi(2:-1:1); end
  vbmeg_inst.plotcmap{inst_id}.foi = foi;
end

ixx = ix_peak;
W = vbmeg_inst.plotcmap{inst_id}.W(ixx,:);

% Calculate timecourse of brain acvitity in Region of Interest
if ~isempty(Jinfo), 
  if ixx==0, 
    J = zeros(length(Tmsec),1); 
  else
    ixx2 = find(sum(abs(W),1)>0);
    W = W(:,ixx2); % ROI window
    Jtmp = zeros(I,length(Jinfo.Tmsec));

    if size(vbmeg_inst.plotcmap{inst_id}.Jact, 3) > 1
      ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
      Jtmp(Jinfo.ix_act_ex,:) ...
        = vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial);
    else
      Jtmp(Jinfo.ix_act_ex,:) ...
        = vbmeg_inst.plotcmap{inst_id}.Jact(:,:);
    end
    
    if length(W(:))>0, 
      J = W*Jtmp(ixx2,:)/sum(W(:));
    end
    
    % holding
    if get(cb4,'Value')==get(cb4,'Max'), 
      J_hold = [J_hold; J];
    else
      J_hold = J;
    end
    vbmeg_inst.plotcmap{inst_id}.J_hold = J_hold;
  end
    
  % Ylabel of graph
  if Jinfo.patch_norm==ON, 
    ylabel_str = 'Dipole moment density [pAm/mm^2]';
  else
    ylabel_str = 'Dipole moment [nA\cdot m]';
  end
elseif ~isempty(TFinfo), 
  if ixx==0, 
    data = zeros(length(TFinfo.freq),length(Tmsec));
  else
    W = sparse(W*TFinfo.Wact);
    ixx = find(W>0);

    c = 0.0; % normalize constant
    data = zeros(length(TFinfo.freq),length(TFinfo.Tmsec));
    for i=1:length(ixx)
      data ...
          = data+W(ixx(i))*vbmeg_inst.plotcmap{inst_id}.data(:,:,ixx(i));
      c = c+W(ixx(i));
    end
    data = data./c;

    % Ylabel of graph
    ylabel_str = 'Frequency [Hz]';
  end
else
  return;
end

%
% Plot timecourse of brain activity
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(0,'CurrentFigure',h_fig);
set(h_fig,'CurrentAxes',h_time);
if ~isempty(Jinfo),
  h_plot = plot(repmat(Tmsec,[size(J_hold,1) 1])',J_hold');
  set(h_plot, 'HitTest', 'off');
  xlim([min(Tmsec) max(Tmsec)]);
  set(h_time,'YDir','normal');
  
  % Set callback function
  plotcmap_str = ['vbmeg_inst.plotcmap{' num2str(inst_id) '}']; 
  command = ['global vbmeg_inst; ' ...
             plotcmap_str '.toi = xrange;' ...
             'inst_id = job_plot_cmap_get_inst_id(gcf);' ...
             'job_plot_cmap_update_timecourse(inst_id);' ...
             'job_plot_cmap_update_spatialpattern(inst_id);'];
  select_xrange('init',gca,'ButtonUpFcn',command,...
                'InitialRange',toi);
else
  if strcmp(TFinfo.freq_scale,'log'), 
    h_img = imagesc(TFinfo.Tmsec,log2(TFinfo.freq),data);
    ylim(log2([min(TFinfo.freq) max(TFinfo.freq)]));
    yy = [2 5 10 20 50 100 200 500 1000 2000 5000 10000];
    [tmp,ix_yy1] = find(yy<=max(TFinfo.freq));
    [tmp,ix_yy2] = find(yy>=min(TFinfo.freq));
    yy = sort(yy(intersect(ix_yy1,ix_yy2)));
    set(h_time,'YDir','normal','YTick',log2(yy),'YTickLabel',yy);
  else
    h_img = imagesc(TFinfo.Tmsec,TFinfo.freq,data);
    ylim([min(TFinfo.freq) max(TFinfo.freq)]);
    set(h_time,'YDir','normal');
    %yy = [2 5 10 20 50 100 200 500 1000 2000 5000 10000];
    %[tmp,ix_yy1] = find(yy<=max(TFinfo.freq));
    %[tmp,ix_yy2] = find(yy>=min(TFinfo.freq));
    %yy = sort(yy(intersect(ix_yy1,ix_yy2)));
    %set(h_time,'YDir','normal','YTick',log2(yy),'YTickLabel',yy);
  end
  
  % Debug code
  if vb_get_verbose==VERBOSE_LEVEL_DEBUG,
    fprintf('job_plot_cmap_update_timecourse\n');
    fprintf('max(max(data))=%e\n',max(max(data)));
    fprintf('TFmax=%e\n',TFmax);
  end
  
  % Color scale
  tfmax = str2num(get(ed10,'String'));
  %if TFmax>=abs(max(max(data)))*10, % Color scale too large
  %  tfmax = abs(max(max(data)));
  %else
  %  tfmax = TFmax;
  %end
  
  % Color range and colorbar
  reset(h_cbar_tf);
  if TFmin<0,     
    caxis(h_time,[-1*tfmax tfmax]);
    
    if datenum(version('-date'))<=733071, % January 29, 2007 or older
      reset(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf);
      colorbar(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf);
    else
      pos = get(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf,'Position');
      delete(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf);
      h_cbar_tf = colorbar('Position',pos);
      vbmeg_inst.plotcmap{inst_id}.h_cbar_tf = h_cbar_tf;
    end

    set(h_cbar_tf,'Ylim',[-1*tfmax tfmax],'XTick',[]);
  else
    caxis(h_time,[0 tfmax]);
    
    if datenum(version('-date'))<=733071, % January 29, 2007 or older
      reset(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf);
      colorbar(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf);
    else
      pos = get(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf,'Position');
      delete(vbmeg_inst.plotcmap{inst_id}.h_cbar_tf);
      h_cbar_tf = colorbar('Position',pos);
      vbmeg_inst.plotcmap{inst_id}.h_cbar_tf = h_cbar_tf;
    end

    set(h_cbar_tf,'Ylim',[0 tfmax],'XTick',[]);
  end
  
  % Set callback function
  plotcmap_str = ['vbmeg_inst.plotcmap{' num2str(inst_id) '}']; 
  if strcmp(TFinfo.freq_scale,'log'), 
    command = ['global vbmeg_inst; ' ...
               plotcmap_str '.toi = [xyrange(1) xyrange(3)];' ...
               plotcmap_str '.foi = [2.^xyrange(2) 2.^xyrange(4)];' ...
               'inst_id = job_plot_cmap_get_inst_id(gcf);' ...
               'job_plot_cmap_update_timecourse(inst_id);' ...
               'job_plot_cmap_update_spatialpattern(inst_id);'];
    vb_select_xyrange('init',h_img,'ButtonUpFcn',command,...
                      'InitialRange',[toi(1) log2(foi(1)) toi(2) ...
                        log2(foi(2))]);
  else
    command = ['global vbmeg_inst; ' ...
               plotcmap_str '.toi = [xyrange(1) xyrange(3)];' ...
               plotcmap_str '.foi = [xyrange(2) xyrange(4)];' ...
               'inst_id = job_plot_cmap_get_inst_id(gcf);' ...
               'job_plot_cmap_update_timecourse(inst_id);' ...
               'job_plot_cmap_update_spatialpattern(inst_id);'];
    vb_select_xyrange('init',h_img,'ButtonUpFcn',command,...
                      'InitialRange',[toi(1) foi(1) toi(2) foi(2)]);
  end
  
end

xlabel('Time [ms]');
ylabel(ylabel_str);
set(h_time, 'Box', 'off');
set(h_time, 'TickDir', 'out');

%
% Update GUI components
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Update text box
set(vbmeg_inst.plotcmap{inst_id}.ed2,'String',num2str(toi(1))); 
set(vbmeg_inst.plotcmap{inst_id}.ed3,'String',num2str(toi(2))); 
if ~isempty(TFinfo),
  set(vbmeg_inst.plotcmap{inst_id}.ed8,'String',num2str(foi(1)));
  set(vbmeg_inst.plotcmap{inst_id}.ed9,'String',num2str(foi(2)));
else
  set(vbmeg_inst.plotcmap{inst_id}.ed8,'String','');
  set(vbmeg_inst.plotcmap{inst_id}.ed9,'String','');
end

set(h_fig,'Pointer','arrow');

return;
