function job_plot_cmap_update_spatialpattern(inst_id, initial_load)
% Update brain activity map. 
%
% [syntax]
% job_plot_cmap_update_spatialpattern(inst_id[,initial_load])
%
% [history]
% ????-??-?? Taku Yoshioka
% 2008-09-04 Taku Yoshioka
% 2008-12-16 Taku Yoshioka
% 2009-05-01 Taku Yoshioka
%  Debug (remove redundant code)
% 2010-08-26 Taku Yoshioka
%  Replace function (vb_plot_cortex->vb_plot_cortex)
% 2010-12-01 taku-y
%  [internal change] 'Jinfo' replaces 'MEGinfo'.
% 2010-12-06 taku-y
%  [enhancement] Jinfo.version>=0.9 supported. 
% 2010-12-08 taku-y
%  [internal change] vb_version_cmp used.
% 2011-01-29 taku-y
%  [enhancement] Activity map plot supported. 
% 2011-02-16 taku-y
%  [enhancement] Cortical area plot supported. 
% 2011-03-16 taku-y
%  [debug] Colorbar scale check is ignored when 'Fix' is checked on GUI.
% 2011-04-01 taku-y
%  [minor] Colorbar fnc argument changed depending on MATLAB version.
% 2011-04-04 taku-y
%  [enhancement] Multiple cortical area plot supported. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig      = vbmeg_inst.plotcmap{inst_id}.h_fig; 
h_space    = vbmeg_inst.plotcmap{inst_id}.h_space;
F          = vbmeg_inst.plotcmap{inst_id}.F;
plot_parm  = vbmeg_inst.plotcmap{inst_id}.plot_parm;
Jinfo      = vbmeg_inst.plotcmap{inst_id}.Jinfo;
Jmin       = vbmeg_inst.plotcmap{inst_id}.Jmin;
Jmax_plot  = vbmeg_inst.plotcmap{inst_id}.Jmax_plot;
Jmin_plot  = vbmeg_inst.plotcmap{inst_id}.Jmin_plot;
TFinfo     = vbmeg_inst.plotcmap{inst_id}.TFinfo;
TFmin      = vbmeg_inst.plotcmap{inst_id}.TFmin;
TFmax_plot = vbmeg_inst.plotcmap{inst_id}.TFmax_plot;
TFmin_plot = vbmeg_inst.plotcmap{inst_id}.TFmin_plot;
ix_peak    = vbmeg_inst.plotcmap{inst_id}.ix_peak;
cb2        = vbmeg_inst.plotcmap{inst_id}.cb2;
cb3        = vbmeg_inst.plotcmap{inst_id}.cb3;
cb7        = vbmeg_inst.plotcmap{inst_id}.cb7;
cb8        = vbmeg_inst.plotcmap{inst_id}.cb8;
cb5        = vbmeg_inst.plotcmap{inst_id}.cb5;
ed5        = vbmeg_inst.plotcmap{inst_id}.ed5;
lb1        = vbmeg_inst.plotcmap{inst_id}.lb1;
lb3        = vbmeg_inst.plotcmap{inst_id}.lb3;
act_file   = vbmeg_inst.plotcmap{inst_id}.act_file;
model_type_original_rb = ...
    vbmeg_inst.plotcmap{inst_id}.model_type_original_rb;
Vtal       = vbmeg_inst.plotcmap{inst_id}.Vtal;
nextDD     = vbmeg_inst.plotcmap{inst_id}.nextDD;
nextIX     = vbmeg_inst.plotcmap{inst_id}.nextIX;
Jmax_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmax_plot_edit;
Jmin_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmin_plot_edit;
area_file = vbmeg_inst.plotcmap{inst_id}.area_file;
area_key  = vbmeg_inst.plotcmap{inst_id}.area_key;

%
% Preparation for cortical surface plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'Pointer','arrow');
drawnow;

% Original/Inflated model
if get(model_type_original_rb,'Value')==1,  
  V = vbmeg_inst.plotcmap{inst_id}.V;
  inf_C = [];
else
  V = vbmeg_inst.plotcmap{inst_id}.Vinf;
  inf_C = vbmeg_inst.plotcmap{inst_id}.inf_C;
end

% Get display parameters
LRflag = [];
if get(cb2,'Value')==get(cb2,'Max'), LRflag = 'L'; end
if get(cb3,'Value')==get(cb3,'Max'), LRflag = [LRflag 'R']; end;
if isempty(LRflag), 
  set(cb2,'Value',get(cb2,'Max')); 
  LRflag = 'L';
end
plot_parm.LRflag = LRflag; 

% Get ROI vertices
if get(cb5,'Value')==get(cb5,'Max'), 
  R = str2num(get(ed5,'String'))*1e-3;
  ix_area = find(nextDD{ix_peak}<=R);
  ix_area = nextIX{ix_peak}(ix_area);
else
  ix_area = [];
end

%
% Get spatial pattern of data using current TOI (and FOI)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
J0 = job_plot_cmap_get_spatialpattern(inst_id);

if isempty(J0), 
  isact = 0; 
else 
  isact=1; 
end
plot_parm.isact = isact; 

% Color scale
Jmax_plot = str2num(get(Jmax_plot_edit,'String'));
Jmin_plot = str2num(get(Jmin_plot_edit,'String'));

if isempty(Jmax_plot), 
  Jmax_plot = max(J0(:));
  set(Jmax_plot_edit,'String',num2str(Jmax_plot));
end

if isempty(Jmin_plot),
  Jmin_plot = Jmax_plot*0.1;
  set(Jmin_plot_edit,'String',num2str(Jmin_plot));
end

%
% Plot brain activities superimposed on the cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(Jinfo),
  if Jmin<0, 
    plot_parm.wmode = 0;
  else
    plot_parm.wmode = 1;
  end
elseif ~isempty(TFinfo),
  if TFmin<0,
    plot_parm.wmode = 0;
  else
    plot_parm.wmode = 1;
  end
end

% Set cortical area
if ~isempty(area_key) && get(cb8,'Value'),
  area_colors = [ 1 0 0; 0 1 0; 0 0 1; 1 1 0; 1 0 1; 0 1 1;
                  1 1 0.5; 0.5 0 0; 0 0.5 1; 0.5 1 0; 1 0.5 1; 0 0 0.5;
                  1 0.5 0; 0 1 0.5; 0.5 0 1; 0 0.5 0; 0.5 1 1; 1 0 0.5;
                  1 0.5 0.5; 0 0.5 0.5; 0.5 1 0.5;
                  0.5 0 0.5; 0.5 0.5 1; 0.5 0.5 0 ];
  
  if ~iscell(area_key), area_key = {area_key}; end
  plot_parm.area.area_file   = area_file;
  plot_parm.area.key         = area_key;
  plot_parm.area.transparent = false;
  
  for i=1:length(area_key)
    tmp_area = vb_get_area(area_file, area_key{i});
    if isfield(tmp_area, 'clr')
        plot_parm.area.clr{i} = tmp_area.clr;
    else
        plot_parm.area.clr{i} ...
            = area_colors(1+mod(i-1,length(area_colors)),:);
    end
  end
end
set(0, 'CurrentFigure', h_fig);
set(h_fig,'CurrentAxes',h_space);
cla;
h = vb_plot_cortex(plot_parm,V,F,inf_C,J0,Jmin_plot,Jmax_plot,ix_area);
if exist('initial_load', 'var') && initial_load
    axis off;
    axis tight;
    axis equal;
    a = xlim;
    xlim(a*1.01);
    set(h_space, 'XLimMode', 'manual');
end
colormap(jet);
try
if datenum(version('-date'))<=733071, % January 29, 2007 or older
  reset(vbmeg_inst.plotcmap{inst_id}.h_cbar);
  colorbar(vbmeg_inst.plotcmap{inst_id}.h_cbar);
else
  pos = get(vbmeg_inst.plotcmap{inst_id}.h_cbar,'Position');
  delete(vbmeg_inst.plotcmap{inst_id}.h_cbar);
  vbmeg_inst.plotcmap{inst_id}.h_cbar = colorbar('Position',pos);
end
catch
end
%
% Plot indicator for selected Vertex
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
plot3(V(ix_peak,1),V(ix_peak,2),V(ix_peak,3),'gx',...
      'MarkerSize',15,'LineWidth',3);

%
% Update standard brain coordinate
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_plot_cmap_update_talcoord(inst_id);
set(h_fig,'Pointer','arrow');

% Attach drag/zoom tool to axes
set(h_fig, 'WindowButtonUpFcn', ['job_plot_cmap_post_rotate(' num2str(inst_id) ');']);
vb_dragzoom(h_space, '3D');

% Set callback for vertex selection
patches = get(h_space, 'Children');
set(patches, 'ButtonDownFcn', {@inner_send_select_vertex, inst_id});

%
% Update cortical area list
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ix_peak = vbmeg_inst.plotcmap{inst_id}.ix_peak;
if ~isempty(area_file) && ~isempty(ix_peak);
  area_key      = vb_get_keyset_area(area_file);
  area_key_list = []; %cell(0,0);
  n = 1;
  
  for i=1:length(area_key)
    tmp = vb_get_area(area_file,area_key{i});
    if ~isempty(find(tmp.Iextract==ix_peak)),
      area_key_list{n} = tmp.key;
      n = n+1;
    end
    
    set(lb3,'String',area_key_list, 'Value', 1);
  end
end

return;

function inner_send_select_vertex(src, evt, inst_id)
global vbmeg_inst;
fig = vbmeg_inst.plotcmap{inst_id}.h_fig;
% double click
if strcmpi(get(fig, 'SelectionType'), 'open')
    job_plot_cmap_selvertex(inst_id);
end


return;



