function job_plot_cmap_temporal_peak(inst_id)
% Search temporal peak of cortical current timecourse
% 
% --- Syntax
% job_plot_cmap_temporal_peak(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-01 Taku Yoshioka
% 2008-10-24 Taku Yoshioka
% 2010-12-01 taku-y
%  [internal change] 'Jinfo' replaces 'MEGinfo'.
% 2010-12-06 taku-y
%  [enhancement] Jinfo.version>=0.9 supported. 
% 2010-12-08 taku-y
%  [internal change] vb_version_cmp used.
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced to "ix_trial"
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end
if isempty(vbmeg_inst.plotcmap{inst_id}.Jact), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
toi      = vbmeg_inst.plotcmap{inst_id}.toi;
ix_peak  = vbmeg_inst.plotcmap{inst_id}.ix_peak;
Jinfo    = vbmeg_inst.plotcmap{inst_id}.Jinfo;
h_fig    = vbmeg_inst.plotcmap{inst_id}.h_fig;
ed7      = vbmeg_inst.plotcmap{inst_id}.ed7;

if isempty(Jinfo), return; end

set(h_fig,'Pointer','watch');
drawnow;

%
% Calculate brain activity map
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ixx = ix_peak;
if ixx==0, 
  J = zeros(length(T),1); 
else
  %tt = ceil([t(1) t(2)]*MEGinfo.SampleFreq/1000-Tstart ...
  %          +vb_meginfo_get_pre_trigger(MEGinfo))+1;
  %tt = ceil((t(1):t(2))*Jinfo.SampleFreq/1000-Tstart+Jinfo.Pretrigger)+1;
  %tt = tt(1):tt(2);
  if vb_version_cmp(Jinfo.version,'>=','0.9-0.a.0')
    tt(1) = ceil(toi(1)*Jinfo.SampleFreq/1000+Jinfo.Pretrigger);
    tt(2) = ceil(toi(2)*Jinfo.SampleFreq/1000+Jinfo.Pretrigger);
    tt = tt(1):tt(2);
  else
    Tstart  = vbmeg_inst.plotcmap{inst_id}.Tstart;
    tt = ceil((toi(1):toi(2))*Jinfo.SampleFreq/1000-Tstart ...
              +Jinfo.Pretrigger)+1;
  end;
  J = job_plot_cmap_get_current(inst_id,ix_trial,tt);
  J = vbmeg_inst.plotcmap{inst_id}.W(ixx,:)*abs(J); 
end;

%
% Find temporal peak
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[tmp,t_peak] = max(abs(J));
t_peak = t_peak+tt(1)-1;
%t_center = (1000/MEGinfo.SampleFreq)*...
%           (Tstart+t_peak-vb_meginfo_get_pre_trigger(MEGinfo));
if vb_version_cmp(Jinfo.version,'>=','0.9-0.a.0')
  t_center = (1000/Jinfo.SampleFreq)*(1+t_peak-Jinfo.Pretrigger);
else
  t_center = (1000/Jinfo.SampleFreq)*(Tstart+t_peak-Jinfo.Pretrigger);
end;

%
% Update time window
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Tsize = str2num(get(ed7,'String'));
if Tsize<0, 
  Tsize=10; 
  set(ed4,'Value','10');
end
vbmeg_inst.plotcmap{inst_id}.toi(1) = t_center-Tsize;
vbmeg_inst.plotcmap{inst_id}.toi(2) = t_center+Tsize;

%
% Update figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_plot_cmap_update_timecourse(inst_id); 
job_plot_cmap_update_spatialpattern(inst_id);

set(h_fig,'Pointer','arrow');

return;
