function job_plot_cmap_spatial_peak(inst_id)
% Update spatial pattern.
% 
% [history]
% 2010-12-01 taku-y
%  [internal change] 'Jinfo' replaces 'MEGinfo'
% 2010-12-06 taku-y
%  [enhancement] Jinfo.version>=0.9 supported. 
% 2010-12-08 taku-y
%  [internal change] vb_version_cmp used. 
% 2010-12-09 taku-y
%  [major] Time-frequency data supported. 
% 2011-02-16 taku-y
%  [enhancement] Show area list including selected vertex. 
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced to "ix_trial"
% 2012-03-09 taku-y
%  [internal change] Modified to use job_plot_cmap_get_spatialpattern. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

% Global variables
toi       = vbmeg_inst.plotcmap{inst_id}.toi;
foi       = vbmeg_inst.plotcmap{inst_id}.foi;
Jinfo     = vbmeg_inst.plotcmap{inst_id}.Jinfo;
TFinfo    = vbmeg_inst.plotcmap{inst_id}.TFinfo;
ix_trial  = vbmeg_inst.plotcmap{inst_id}.ix_trial;
h_fig     = vbmeg_inst.plotcmap{inst_id}.h_fig;
ix_peak   = vbmeg_inst.plotcmap{inst_id}.ix_peak;
nextDD    = vbmeg_inst.plotcmap{inst_id}.nextDD;
nextIX    = vbmeg_inst.plotcmap{inst_id}.nextIX;
ed5       = vbmeg_inst.plotcmap{inst_id}.ed5;
area_file = vbmeg_inst.plotcmap{inst_id}.area_file;
lb3       = vbmeg_inst.plotcmap{inst_id}.lb3;

set(h_fig,'Pointer','watch');
drawnow;

if isempty(nextDD), 
  vb_disp('No cortical surface model is loaded.');
  return;
else
  I = length(nextDD);
end

% ROI for search
R = str2num(get(ed5,'String'))*1e-3;
if R<0, R=0.1; set(ed5,'String','100'); end
ixx = find(nextDD{ix_peak}<=R);
ixx = nextIX{ix_peak}(ixx);

% Get time (and frequency) window
if isempty(TFinfo), 
  if isempty(Jinfo), 
    return;
  else
    J0 = job_plot_cmap_get_spatialpattern(inst_id);
    J0 = abs(J0(ixx));
    % Time window
    %if vb_version_cmp(Jinfo.version,'>=','0.9-0.a.0'), 
    %  tt(1) = ceil(toi(1)*Jinfo.SampleFreq/1000+Jinfo.Pretrigger);
    %  tt(2) = ceil(toi(2)*Jinfo.SampleFreq/1000+Jinfo.Pretrigger);
    %  tt = tt(1):tt(2);
    %else
    %  Tstart  = vbmeg_inst.plotcmap{inst_id}.Tstart;
    %  tt = ceil((toi(1):toi(2))*Jinfo.SampleFreq/1000-Tstart ...
    %            +Jinfo.Pretrigger)+1;
    %end
    %
    % Temporal sum of absolute value of cortical current
    %J0 = job_plot_cmap_get_current(inst_id,ix_trial,tt); 
    %J0 = abs(mean(J0,2));
    %J0 = J0(ixx);
  end
else
  % Time window
  tt(1) = ceil(toi(1)*TFinfo.SampleFreq/1000+TFinfo.Pretrigger);
  tt(2) = ceil(toi(2)*TFinfo.SampleFreq/1000+TFinfo.Pretrigger);
  tt = tt(1):tt(2);
  
  % Frequency window
  [tmp,ix(1)] = min(abs(TFinfo.freq-foi(1)));
  [tmp,ix(2)] = min(abs(TFinfo.freq-foi(2)));
  if ix(1)>ix(2), 
    ff = ix(2):ix(1); 
  else
    ff = ix(1):ix(2);
  end
  
  % Vertex indices to be searched
  [ixx,ixxx] = intersect(TFinfo.ix_act,ixx);
  if isempty(ixx), 
    vb_disp(['No vertex have time-frequency data within the search ' ...
             'range. You should set larger search radius.']);
    return;
  end
  
  % Time-frequency sum of absolute value of data
  tmp = sum(sum(abs(vbmeg_inst.plotcmap{inst_id}.data(tt,ff,ixxx)),1),2);
  J0 = zeros(I,1);
  J0(ixx) = tmp;
end

[tmp,ixp] = max(J0);
vbmeg_inst.plotcmap{inst_id}.ix_peak = ixx(ixp);

%
% Update cortical area list
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ixp = ixx(ixp);

if ~isempty(area_file),
  area_key      = vb_get_keyset_area(area_file);
  area_key_list = []; %cell(0,0);
  n = 1;
  
  for i=1:length(area_key)
    tmp = vb_get_area(area_file,area_key{i});
    if ~isempty(find(tmp.Iextract==ixp)),
      area_key_list{n} = tmp.key;
      n = n+1;
    end
    
    set(lb3,'String',area_key_list);
  end
end

%
% Update figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_plot_cmap_update_timecourse(inst_id); 
job_plot_cmap_update_spatialpattern(inst_id);

set(h_fig,'Pointer','arrow');

return;
