function job_plot_cmap_show_loaded_files(inst_id)
% Show loaded files. 
%
% [syntax]
% job_plot_cmap_show_loaded_files(inst_id)
%
% [history]
% 2008-09-01 Taku Yoshioka
% 2010-12-09 taku-y
%  [minor enhancement] Time-frequency file supported. 
% 2012-02-17 taku-y
% [minor] brainfile -> brain_file
% 2012-02-27 taku-y
% [minor] Cortical area/activity files are also shown. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

if isempty(vbmeg_inst.plotcmap{inst_id}.tf_file),
  str = sprintf(['Estimated current file     : %s \n' ...
                 'Cortical surface model file: %s \n' ...
                 'Cortical area file         : %s \n' ...
                 'Cortical activity file     : %s'], ...
                vbmeg_inst.plotcmap{inst_id}.curr_file, ...
                vbmeg_inst.plotcmap{inst_id}.brain_file, ...
                vbmeg_inst.plotcmap{inst_id}.area_file, ...
                vbmeg_inst.plotcmap{inst_id}.act_file);
  h = msgbox(str,'Loaded files','modal');
else
  str = sprintf(['Time-frequency file        : %s \n' ...
                 'Cortical surface model file: %s \n' ...
                 'Cortical area file         : %s \n' ...
                 'Cortical activity file     : %s'], ...
                vbmeg_inst.plotcmap{inst_id}.tf_file, ...
                vbmeg_inst.plotcmap{inst_id}.brain_file, ...
                vbmeg_inst.plotcmap{inst_id}.area_file, ...
                vbmeg_inst.plotcmap{inst_id}.act_file);
  h = msgbox(str,'Loaded files','modal');
end

return;
