function job_plot_cmap_setting_dlg_callback(H, hObj)
% callback function for job_plot_cmap_setting_dlg.m
% [USAGE]
%    job_plot_cmap_setting_dlg_callback(H);
% [IN]
%       H : component handles
%    hObj : action component handle
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% disp(get(hObj, 'Tag')); % debug

D = vb_define_extension;

switch(hObj)
    case H.data_file_current_radiobutton
         change_file_type(H, 1);
    case H.data_file_tf_radiobutton
         change_file_type(H, 2);
    case {H.tf_file_text, H.current_file_text, H.brain_file_text,...
          H.area_file_text, H.act_file_text, H.load_mode_text}
         % Show description
         description = getappdata(hObj, 'description');
         set(H.description_edit, 'String', description);
    case H.brain_file_push
        [d_, f_] = vb_file_select(...
                    {D.BRAIN_EXTENSION}, 'Select Cortical model file');
        if ~isempty(d_)
            set(H.brain_file_update_checkbox, 'Value', 1);
            job_plot_cmap_setting_dlg_set_file(...
                               H, [d_ filesep, f_{1}], 'brain_file');
        end
    case H.brain_file_edit
        file = get(hObj, 'String');
        res = job_plot_cmap_setting_dlg_set_file(H, file, 'brain_file');
        if res == FAILURE
            inner_error_file_specified(hObj, 'Cortical model file');
        end
    case H.area_file_push
        [d_, f_] = vb_file_select(...
                    {D.AREA_EXTENSION}, 'Select Cortical area file');
        if ~isempty(d_)
            set(H.area_file_update_checkbox, 'Value', 1);
            job_plot_cmap_setting_dlg_set_file(...
                                H, [d_ filesep, f_{1}], 'area_file');
        end
    case H.area_file_edit
        file = get(hObj, 'String');
        res = job_plot_cmap_setting_dlg_set_file(H, file, 'area_file');
        if res == FAILURE
            inner_error_file_specified(hObj, 'Cortical area file');
        end
    case H.act_file_push
        [d_, f_] = vb_file_select(...
                    {D.FMRI_EXTENSION}, 'Select Cortical activity file');
        if ~isempty(d_)
            set(H.act_file_update_checkbox, 'Value', 1);
            job_plot_cmap_setting_dlg_set_file(...
                              H, [d_ filesep, f_{1}], 'act_file');
        end
    case H.act_file_edit
        file = get(hObj, 'String');
        res = job_plot_cmap_setting_dlg_set_file(H, file, 'act_file');
        if res == FAILURE
            inner_error_file_specified(hObj, 'Cortical act file');
        end
    case H.current_file_push
        [d_, f_] = vb_file_select(...
                    {D.CURRENT_EXTENSION}, 'Select Current file');
        if ~isempty(d_)
            current_file = [d_, filesep, f_{1}];
            [mode, trial] = inner_get_current_file_settings(H);
            job_plot_cmap_setting_dlg_set_current_file(...
                                                     H, current_file,...
                                                     mode, trial);
        end
    case H.current_file_edit
        file = get(hObj, 'String');
        [mode, trial] = inner_get_current_file_settings(H);
        res = job_plot_cmap_setting_dlg_set_current_file(...
                                                     H, file,...
                                                     mode, trial);
        if res == FAILURE
            inner_error_file_specified(hObj, 'Current file');
        end
    case H.current_file_mode_average_radiobutton
        change_load_mode(H, 'ave');
        set(H.current_file_update_checkbox, 'Value', 1);
    case H.current_file_mode_raw_radiobutton
        change_load_mode(H, 'raw');
        set(H.current_file_update_checkbox, 'Value', 1);
    case H.current_file_mode_raw_edit
        change_load_mode(H, 'raw');
        % get previous valid input
        prev = getappdata(hObj, 'prev');
        if isempty(prev), prev = 1; end
        % get maximum trial
        max_trial = getappdata(H.max_trial_text, 'max');
        if isempty(max_trial), max_trial = 1; end
        trial = str2double(get(hObj, 'String'));
        trial = round(trial);
        set(hObj, 'String', num2str(trial));
        % check input
        if isnan(trial) || trial > max_trial || trial <= 0
            errordlg('Trial index is invalid.', 'Trial');
            set(hObj, 'String', num2str(prev));
            return;
        end
        if prev == trial, return; end
        % remember collect value for the next invalid input.
        setappdata(hObj, 'prev', trial);
        set(H.current_file_update_checkbox, 'Value', 1);

    case H.tf_file_push
        [d_, f_] = vb_file_select(...
                    {'.tf.mat'}, 'Select Time frequency file');
        if ~isempty(d_)
            set(H.tf_file_update_checkbox, 'Value', 1);
            job_plot_cmap_setting_dlg_set_file(...
                                   H, [d_, filesep, f_{1}], 'tf_file');
        end
    case H.tf_file_edit
        file = get(hObj, 'String');
        res = job_plot_cmap_setting_dlg_set_file(H, file, 'tf_file');
        if res == FAILURE
            inner_error_file_specified(hObj, 'Time frequency file');
        end
    case H.ok_push
        set(H.figure, 'Visible', 'off');
        return;
    case H.cancel_push
        closereq;
        return;
end

ret = job_plot_cmap_setting_dlg_is_requirement_filled(H.figure);
if ret
    set(H.ok_push, 'Enable', 'on');
else
    set(H.ok_push, 'Enable', 'off');
end


function change_file_type(H, type)
% change selection file type
% [IN]
%    H : component handles
% type : = 1 : current file selection
%        = 2 : time frequency file selection
%
comp_current = [H.current_file_text, ...
                H.current_file_edit, ...
                H.current_file_push, ...
                H.current_file_update_checkbox, ...
                H.load_mode_frame, ...
                H.load_mode_text, ...
                H.current_file_mode_average_radiobutton, ...
                H.current_file_mode_raw_radiobutton, ...
                H.current_file_mode_raw_edit, ...
                H.max_trial_text];
comp_tf      = [H.tf_file_text, ...
                H.tf_file_edit, ...
                H.tf_file_push, ...
                H.tf_file_update_checkbox];

% All component set invisible
set([comp_current, comp_tf], 'Visible', 'off');

if type == 1
    % Current file component visible
    set(comp_current, 'Visible', 'on');
    set(H.data_file_current_radiobutton, 'Value', 1);
    set(H.data_file_tf_radiobutton, 'Value', 0);
    tbl  = vb_define_description_table;
    desc = vb_table_query_value(tbl, 'jpcp_current');
    set(H.description_edit, 'String', ...
        sprintf(['*: required parameter(s).', desc]));
else
    % Timefrequency file component visible
    set(comp_tf, 'Visible', 'on');
    set(H.data_file_current_radiobutton, 'Value', 0);
    set(H.data_file_tf_radiobutton, 'Value', 1);
    tbl  = vb_define_description_table;
    desc = vb_table_query_value(tbl, 'jpcp_timefreq');
    set(H.description_edit, 'String', ...
        sprintf(['*: required parameter(s).', desc]));
end

function change_load_mode(H, mode)
% change load mode(average or raw mode)
% [IN]
%    H : component handles
% mode : 'ave' or 'raw'

% uncheck both buttons
comp = [H.current_file_mode_average_radiobutton, 
        H.current_file_mode_raw_radiobutton];
set(comp, 'Value', 0);

switch(mode)
    case 'ave'
        set(H.current_file_mode_average_radiobutton, ...
            'Value', 1, 'Enable', 'Inactive');
        set(H.current_file_mode_raw_radiobutton, 'Enable', 'on');
    case 'raw'
        set(H.current_file_mode_raw_radiobutton, ...
            'Value', 1, 'Enable', 'Inactive');
        set(H.current_file_mode_average_radiobutton, 'Enable', 'on');
    otherwise
        error('Unknown mode was specified.');
end

function [mode, trial] = inner_get_current_file_settings(H)
% get mode(average/raw) and trial number from GUI

if get(H.current_file_mode_average_radiobutton, 'Value')
    mode = 'ave';
else
    mode = 'raw';
end
trial = str2double(get(H.current_file_mode_raw_edit, 'String'));


function inner_error_file_specified(hObj, dlg_title)
% Show error dialog and set focus to an edit box
h = errordlg('Specified file is invalid.', dlg_title);
waitfor(h);
uicontrol(hObj);
