function job_plot_cmap_register_area(inst_id)
% Store selected area into cortical area file
% 
% --- Syntax
% function job_plot_cmap_register_area(inst_id)
%
% --- History
% 2008-09-29 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end
if isempty(vbmeg_inst.plotcmap{inst_id}.Jact), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ix_peak = vbmeg_inst.plotcmap{inst_id}.ix_peak;
ed5 = vbmeg_inst.plotcmap{inst_id}.ed5;
nextDD = vbmeg_inst.plotcmap{inst_id}.nextDD;
nextIX = vbmeg_inst.plotcmap{inst_id}.nextIX;

%
% Store cortical area
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
R = str2num(get(ed5,'String'))*1e-3;
ix_area = find(nextDD{ix_peak}<=R);
ix_area = nextIX{ix_peak}(ix_area);

[brain_dir,brain_file] ...
    = vb_file_select({'.area.mat'},'Select area file');

if ~isempty(brain_file),
  areafile = [brain_dir filesep brain_file{1}];

  prompt  = {'Enter arbitrary string as ID of area'};
  title   = 'Area registration';
  lines= 1;
  def     = {'new area'};
  str = inputdlg(prompt,title,lines,def);
  
  if isempty(str),
    return;
  elseif ~isempty(str{1}), 
    area_new.key = str{1};
    area_new.Iextract = ix_area;
  
    vb_add_area(areafile,area_new);
  end
end

return;
