function job_plot_cmap_print_spatialpattern(inst_id)
% Update spatial pattern of cortical activities (estimated current)
% 
% [syntax]
% function job_plot_cmap_print_spatialpattern(inst_id)
%
% [history]
% ????-??-?? Taku Yoshioka
% 2008-09-01 Taku Yoshioka
% 2010-08-26 Taku Yoshioka
%  Replace function (vb_plot_cortex->vb_plot_cortex)
% 2010-12-01 taku-y
%  [internal change] 'Jinfo' replaces 'MEGinfo'. 
% 2010-12-06 taku-y
%  [enhancement] Jinfo.version>=0.9 supported. 
% 2010-12-08 taku-y
%  [internal change] vb_version_cmp used. 
% 2010-12-13 taku-y
%  [enhancement] Time-frequency data supported.
%  [internal change] Implamentation adapted from
%  job_plot_cmap_update_spatialpattern. 
% 2011-01-11 taku-y
%  [minor] inputdlg replaced by vb_property_dlg. 
% 2011-04-04 taku-y
%  [enhancement] Multiple cortical area plot supported. 
% 2011-09-05 taku-y
%  [enhancement] Parameter 'Colormap' supported.
% 2011-10-29 taku-y
%  [debug] [minor] Double lighting for fold model fixed. 
%  [enhancement] [minor] Parameter 'Light intensity' supported.
% 2012-02-09 taku-y
%  [enhancement] Print option support. 
% 2012-10-15 taku-y
%  [minor] Modified print options.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end

% --- Global variables
h_space    = vbmeg_inst.plotcmap{inst_id}.h_space;
F          = vbmeg_inst.plotcmap{inst_id}.F;
plot_parm  = vbmeg_inst.plotcmap{inst_id}.plot_parm;
Jinfo      = vbmeg_inst.plotcmap{inst_id}.Jinfo;
Jmin       = vbmeg_inst.plotcmap{inst_id}.Jmin;
Jmax_plot  = vbmeg_inst.plotcmap{inst_id}.Jmax_plot;
Jmin_plot  = vbmeg_inst.plotcmap{inst_id}.Jmin_plot;
TFinfo     = vbmeg_inst.plotcmap{inst_id}.TFinfo;
TFmin      = vbmeg_inst.plotcmap{inst_id}.TFmin;
TFmax_plot = vbmeg_inst.plotcmap{inst_id}.TFmax_plot;
TFmin_plot = vbmeg_inst.plotcmap{inst_id}.TFmin_plot;
cb1        = vbmeg_inst.plotcmap{inst_id}.cb1;
cb2        = vbmeg_inst.plotcmap{inst_id}.cb2;
cb3        = vbmeg_inst.plotcmap{inst_id}.cb3;
cb8        = vbmeg_inst.plotcmap{inst_id}.cb8;
model_type_original_rb = ...
    vbmeg_inst.plotcmap{inst_id}.model_type_original_rb;
Jmax_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmax_plot_edit;
Jmin_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmin_plot_edit;
area_file = vbmeg_inst.plotcmap{inst_id}.area_file;
area_key  = vbmeg_inst.plotcmap{inst_id}.area_key;

% --- Preparation for cortical surface plot

% Original/Inflated model
if get(model_type_original_rb,'Value')==1,  
  V = vbmeg_inst.plotcmap{inst_id}.V;
  inf_C = [];
else
  V = vbmeg_inst.plotcmap{inst_id}.Vinf;
  inf_C = vbmeg_inst.plotcmap{inst_id}.inf_C;
end

% Get display parameters
LRflag = [];
if get(cb2,'Value')==get(cb2,'Max'), LRflag = 'L'; end
if get(cb3,'Value')==get(cb3,'Max'), LRflag = [LRflag 'R']; end;
if isempty(LRflag), 
  set(cb2,'Value',get(cb2,'Max')); 
  LRflag = 'L';
end
plot_parm.LRflag = LRflag; 

% --- Get spatial pattern of data using current TOI (and FOI)
J0 = job_plot_cmap_get_spatialpattern(inst_id);

if isempty(J0), 
  isact = 0; 
else 
  isact=1; 
end
plot_parm.isact = isact;
[az,el] = view(h_space); 

% Color scale
Jmax_plot = str2num(get(Jmax_plot_edit,'String'));
Jmin_plot = str2num(get(Jmin_plot_edit,'String'));

if isempty(Jmax_plot), 
  Jmax_plot = max(J0(:));
  set(Jmax_plot_edit,'String',num2str(Jmax_plot));
end

if isempty(Jmin_plot),
  Jmin_plot = Jmax_plot*0.1;
  set(Jmin_plot_edit,'String',num2str(Jmin_plot));
end

% Show dialog to input max and threshold of colormap
property_names = {'Colorbar','Max','Min','Colorbar', ...
                  'Light intensity','Print option'};
default_values{1} = num2str(plot_parm.flag_colorbar);
default_values{2} = num2str(Jmax_plot);
default_values{3} = num2str(Jmin_plot);
if plot_parm.cmap==1, 
  default_values{4} = 'hot';
else
  default_values{4} = 'jet';
end
if isempty(inf_C), % for fold model
  default_values{5} = '0.6';
else
  default_values{5} = '1.0';
end
default_values{6} = plot_parm.str_print_format;

% debug code
vb_disp(['job_plot_cmap_print_spatialpattern'],'DEBUG');
for i=1:6
  tmp_str = sprintf('default_values{%d}=%s',i,default_values{i});
  vb_disp(tmp_str,'DEBUG');
end

% open dialog
description    ...
    = {'Colorbar is attached (1) or not (0).', ...
       'Maximum value of the absolute value plotted.', ...
       ['Minimum threshold; vertices with values lower than ' ...
        'the threshold are not plotted.'], ...
       'Colormap', ...
       'Relative intensity from 0 to 1', ...
       'Print option (such as ''-dpng'')'};
values = vb_property_dlg(property_names,default_values,description);

if isempty(values),
  return;
end

iscbar    = str2num(values{1});
Jmax_plot = str2num(values{2});
Jmin_plot = str2num(values{3});
cmap_str  = values{4};
intensity = str2num(values{5});
opt_print = values{6};

% --- Plot brain activities superimposed on the cortical surface model
if ~isempty(Jinfo),
  if Jmin<0, 
    plot_parm.wmode = 0;
  else
    plot_parm.wmode = 1;
  end
elseif ~isempty(TFinfo),
  if TFmin<0,
    plot_parm.wmode = 0;
  else
    plot_parm.wmode = 1;
  end
end

% Set cortical area
if ~isempty(area_key) && get(cb8,'Value'),
  area_colors = [ 1 0 0; 0 1 0; 0 0 1; 1 1 0; 1 0 1; 0 1 1;
                  1 1 0.5; 0.5 0 0; 0 0.5 1; 0.5 1 0; 1 0.5 1; 0 0 0.5;
                  1 0.5 0; 0 1 0.5; 0.5 0 1; 0 0.5 0; 0.5 1 1; 1 0 0.5;
                  1 0.5 0.5; 0 0.5 0.5; 0.5 1 0.5;
                  0.5 0 0.5; 0.5 0.5 1; 0.5 0.5 0 ];
  
  if ~iscell(area_key), area_key = {area_key}; end
  plot_parm.area.area_file   = area_file;
  plot_parm.area.key         = area_key;
  plot_parm.area.transparent = true;
  
  for i=1:length(area_key)
    plot_parm.area.clr{i} ...
        = area_colors(1+mod(i-1,length(area_colors)),:);
  end
end

h_fig = figure;
vb_plot_cortex(plot_parm,V,F,inf_C,J0,Jmin_plot,Jmax_plot); 
axis off;
axis equal;
axis tight;

if strcmp(cmap_str,'hot'),
  colormap(hot);
else
  colormap(jet);
end

if iscbar & Jmax_plot>0,
  h = colorbar;
  if plot_parm.wmode==0,
    set(h,'YLim',[-1*Jmax_plot Jmax_plot]);
  else
    set(h,'YLim',[0 Jmax_plot]);
  end
end

% --- Print figure
view([az el]);
if ~isempty(inf_C), 
  lh = camlight('headlight'); % add light for printing inflate model
else % update light position
  c = get(gca,'Children');
  for i=1:length(c)
    if strcmp(get(c(i),'Type'),'light'),
      lh = c(i);
      camlight(lh,'headlight');
    end
  end
end

% update light intensity
cl = get(lh,'Color');
set(lh,'Color',intensity*cl);

vb_epsfig(gcf,0.5,15);

if ~isempty(findstr(opt_print,'-dpng')), 
  [fig_dir,fig_file] = vb_file_select({'.png'},'Save figure',true);
else
  [fig_dir,fig_file] = vb_file_select({'.eps'},'Save figure',true);
end

if ~isempty(fig_file), 
  figfile = [fig_dir filesep fig_file{1}];
  print(h_fig,opt_print,figfile);
end

if ishandle(h_fig)
    delete(h_fig);
end

return;