function job_plot_cmap_change_Jplot(inst_id)
% Check Jplot range and update spatial pattern
%
% [syntax]
% job_plot_cmap_change_Jplot(inst_id)
%
% [history]
% 2008-12-16 Taku Yoshioka
% 2011-01-29 taku-y
%  [enhancement] Activity map plot supported. 
% 2011-03-16 taku-y
%  [debug] Colorbar scale check is ignored when 'Fix' is checked on GUI.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end
%if isempty(vbmeg_inst.plotcmap{inst_id}.Jact), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_cbar = vbmeg_inst.plotcmap{inst_id}.h_cbar;
Jmax = vbmeg_inst.plotcmap{inst_id}.Jmax;
Jmax_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmax_plot_edit;
Jmin_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmin_plot_edit;
cb1            = vbmeg_inst.plotcmap{inst_id}.cb1;
cb7            = vbmeg_inst.plotcmap{inst_id}.cb7;
xxP            = vbmeg_inst.plotcmap{inst_id}.xxP;

%
% Check activity map
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(xxP) && get(cb7,'Value'), 
  Jmax = max(abs(xxP));
end

%
% Check value
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Jmax_plot = str2num(get(Jmax_plot_edit,'String'));
Jmin_plot = str2num(get(Jmin_plot_edit,'String'));

if get(cb1,'Value')~=get(cb1,'Max'), 
  if Jmin_plot>=0.9*Jmax, Jmin_plot = 0.9*Jmax; 
  elseif Jmin_plot<0, Jmin_plot = 0; end

  if Jmax_plot>Jmax, Jmax_plot = Jmax; 
  elseif Jmax_plot<Jmin_plot, Jmax_plot = Jmin_plot;
  elseif Jmax_plot<1e-10*Jmax, Jmax_plot = 1e-10*Jmax; end
end

vbmeg_inst.plotcmap{inst_id}.Jmax_plot = Jmax_plot;
vbmeg_inst.plotcmap{inst_id}.Jmin_plot = Jmin_plot;
set(Jmax_plot_edit,'String',num2str(Jmax_plot));
set(Jmin_plot_edit,'String',num2str(Jmin_plot));

%
% Change axis and Update spatial pattern
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%set(h_cbar,'Ylim',[0 Jmax_plot]);
job_plot_cmap_update_spatialpattern(inst_id);
