function job_edit_act_select_vertex(inst_id)
% Select vertex
% 
% --- Syntax
% job_edit_act_select_vertex(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-04 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
V = vbmeg_inst.editact{inst_id}.V;
Vinf = vbmeg_inst.editact{inst_id}.Vinf;
ed5 = vbmeg_inst.editact{inst_id}.ed5;
model_type_fold_rb = vbmeg_inst.editact{inst_id}.model_type_fold_rb;

%
% Select vertex
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if get(model_type_fold_rb,'Value')~=get(model_type_fold_rb,'Max'), 
  V = Vinf;
end

tmp = (select3d)';
if length(tmp)==0, return; end

% Search nearest vertex
tmp = repmat(tmp, [size(V,1) 1]);
[tmp,ix] = min(sum((tmp - V).^2, 2));

% Vertex index
set(ed5,'String',num2str(ix));
vbmeg_inst.editact{inst_id}.ix = ix;

%
% Update plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_edit_act_update_spatialpattern(inst_id);
