function job_edit_act(brainfile,actfile)
% Start up GUI for editing activity information
%
% --- Syntax
% function job_edit_act(brainfile,actfile)
%
% --- History
% 2007-02-15 Taku Yoshioka
% 2008-09-04 Taku Yoshioka
% 2009-05-01 Taku Yoshioka
%   'Replace' button was added. 
% 2009-05-22 Taku Yoshioka
%   Several buttons were added. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Input parameter check
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin<2, actfile = []; end
if nargin<1, brainfile = []; end

inst_id = create_instance;
if isempty(inst_id), return; end; 

%
% Create GUI and update plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
create_GUI(inst_id,brainfile,actfile);
job_edit_act_update_spatialpattern(inst_id);

%%%
%%% Inner functions 
%%%

function inst_id = create_instance
% Create instance of GUI
% 
% --- Syntax
% inst_id = create_instance
%
% --- History
% 2007-02-15 Taku Yoshioka

global vbmeg_inst

if isfield(vbmeg_inst,'editact'),
  for inst_id=1:vbmeg_inst.const.EDITACT_MAX
    if isempty(vbmeg_inst.editact{inst_id}), return; end;
  end
  fprintf(['The number of instances of ''job_edit_act''' ...
       ' GUIs reaches the maximum number.\n']);
  inst_id = [];
elseif isfield(vbmeg_inst,'const'), 
  vbmeg_inst.editact = cell(vbmeg_inst.const.EDITACT_MAX,1);
  inst_id = 1;
else
  fprintf(['''vbmeg_inst'' was not correct. You have to invoke' ...
       '''vbmeg'' to create an instance of VBMEG.\n']); 
  inst_id = []; 
end

function create_GUI(inst_id,brainfile,actfile)
% Create GUI
%
% --- Syntax
% create_GUI(inst_id,brainfile,actfile)
%
% --- History
% 2007-02-15 Taku Yoshioka
% 2008-09-04 Taku Yoshioka
% 2009-05-01 Taku Yoshioka

global vbmeg_inst;

%
% Initialize parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Cortical surface model
editact.brainfile = [];
editact.V = [];
editact.Vinf = []; 
editact.F = [];
editact.inf_C = [];
editact.Vtal = [];
editact.Vmni = [];
editact.nextDD = [];
editact.nextID = [];

% Activity map
editact.actfile = [];
editact.xxP = []; 

% Display parameters
editact.ix = [];

% Selected vertex
%editact.ix = 1;

%
% GUI open
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = open('job_edit_act.fig');
set(h_fig,'HandleVisibility','on');
drawnow; 
set(h_fig,'Pointer','watch');

%
% Handles of GUI components
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
editact.h_fig = h_fig;
editact.h_space = get_child_handle(h_fig,'axes1');
editact.h_cbar = get_child_handle(h_fig,'colorbar');
editact.ed2 = get_child_handle(h_fig,'radius');
editact.ed4 = get_child_handle(h_fig,'tal_coord');
editact.ed5 = get_child_handle(h_fig,'vertex_index');
editact.ed6 = get_child_handle(h_fig,'color_scale');
editact.lb1 = get_child_handle(h_fig,'activity_map_list');
editact.pb2 = get_child_handle(h_fig,'clear');
editact.pb3 = get_child_handle(h_fig,'average');
editact.pb4 = get_child_handle(h_fig,'maximum');
editact.pb5 = get_child_handle(h_fig,'histogram');
editact.pb6 = get_child_handle(h_fig,'gaussian');
editact.pb7 = get_child_handle(h_fig,'step_function');
editact.pb8 = get_child_handle(h_fig,'registration');
editact.pb9 = get_child_handle(h_fig,'delete');
editact.pb11 = get_child_handle(h_fig,'normalize');
editact.pb12 = get_child_handle(h_fig,'undo');
editact.pb13 = get_child_handle(h_fig,'print');
editact.pb15 = get_child_handle(h_fig,'replace');
editact.pb16 = get_child_handle(h_fig,'left_button');
editact.pb17 = get_child_handle(h_fig,'right_button');
editact.pb18 = get_child_handle(h_fig,'top_button');
editact.pb19 = get_child_handle(h_fig,'bottom_button');
editact.cb1 = get_child_handle(h_fig,'left_hemi');
editact.cb2 = get_child_handle(h_fig,'right_hemi');
editact.rb1 = get_child_handle(h_fig,'talairach');
editact.rb2 = get_child_handle(h_fig,'mni');
editact.operation_text   = get_child_handle(h_fig,'operation_text');
editact.zt   = get_child_handle(h_fig,'zoom_toggle');
editact.model_type_inflate_rb = get_child_handle(h_fig,'inflate');
editact.model_type_fold_rb = get_child_handle(h_fig,'folded');
editact.load_cortex_menu ...
    = get_child_handle(get_child_handle(h_fig,'file_menu'), ...
                       'load_cortex_menu');
editact.load_actmap_menu ...
    = get_child_handle(get_child_handle(h_fig,'file_menu'), ...
                       'load_actmap_menu');
editact.loaded_files_menu ...
    = get_child_handle(get_child_handle(h_fig,'file_menu'), ...
                       'loaded_files_menu');
editact.close_menu ...
    = get_child_handle(get_child_handle(h_fig,'file_menu'), ...
                       'close_menu');
editact.manual_menu ...
    = get_child_handle(get_child_handle(h_fig,'help_menu'), ...
                       'manual');
    
% Set GUI values
set(editact.ed2,'String','6');
set(editact.lb1,'Value',1);

editact.plot_parm = vb_set_plot_parm;
editact.plot_parm.index = [];
editact.plot_parm.LRflag = 'LR';

% Initialize GUI components
set(editact.h_space,'XTick',[],'YTick',[]);
set(editact.h_cbar,'XTick',[],'YTick',[]);

%
% Callback functions
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
inst_str = num2str(inst_id); 
editact_str = ['vbmeg_inst.editact{' inst_str '}'];

% Remove instance after window close
command = ['global vbmeg_inst; '...
       'vbmeg_inst.editact{' inst_str '}=[];'];
set(h_fig,'DeleteFcn',command);

% Change filter radius
command = ['job_edit_act_change_radius(' inst_str ');']; 
set(editact.ed2,'Callback',command);

% Change vertex index
command = ['job_edit_act_change_vertex(' inst_str ');']; 
set(editact.ed5,'Callback',command);

% Clear activity map
command = ['job_edit_act_clear(' inst_str ');'];
set(editact.pb2,'Callback',command);

% Replace activity map
command = ['job_edit_act_replace(' inst_str ');'];
set(editact.pb15,'Callback',command);

% Average activity maps
command = ['job_edit_act_average(' inst_str ');'];
set(editact.pb3,'Callback',command);

% Maximum activity maps
command = ['job_edit_act_maximum(' inst_str ');'];
set(editact.pb4,'Callback',command);

% Display histogram
command = ['job_edit_act_plot_histogram(' inst_str ');'];
set(editact.pb5,'Callback',command);

% Apply Gaussian filter
command = ['job_edit_act_gauss_filter(' inst_str ');'];
set(editact.pb6,'Callback',command);

% Apply step function filter
command = ['job_edit_act_step_filter(' inst_str ');'];
set(editact.pb7,'Callback',command);

% Activity map registration
command = ['job_edit_act_registration(' inst_str ');'];
set(editact.pb8,'Callback',command);

% Delete activity map
command = ['job_edit_act_delete(' inst_str ');'];
set(editact.pb9,'Callback',command);

% Normalize
command = ['job_edit_act_normalize(' inst_str ');'];
set(editact.pb11,'Callback',command);

% Undo
command = ['job_edit_act_undo(' inst_str ');'];
set(editact.pb12,'Callback',command);

% Print
command = ['job_edit_act_print_spatialpattern(' inst_str ');'];
set(editact.pb13,'Callback',command);

% Zoom
command = ['job_edit_act_change_zoom(' inst_str ');'];
set(editact.zt, 'Callback', command);
if vb_matlab_version('<=', '7.5.0')
    set(editact.zt, 'Visible', 'on');
else
    str       = get(editact.operation_text, 'String');
    zoom_help = '   Zoom: mouse wheel';
    set(editact.operation_text, 'String', [str, zoom_help]);
    set(editact.zt, 'Visible', 'off');
end

% Change presented hemisphere
command = ['job_edit_act_change_hemi(' inst_str ');'];
set(editact.cb1,'Callback',command);
set(editact.cb2,'Callback',command);

% Model type
model_type_group = [editact.model_type_inflate_rb,
                    editact.model_type_fold_rb];
command = ['job_edit_act_change_modeltype(' inst_str ');'];
set(model_type_group, 'Callback', command);
set(model_type_group, 'Value', 0); % both off
set(editact.model_type_inflate_rb,'Value',1);

% Load cortical surface model
command = ['[brain_dir,brain_file] = vb_file_select' ...
           '({''.brain.mat''},''Load cortical model'');' ...
           'if ~isempty(brain_file), ' ...
       'job_edit_act_load_cortex(' inst_str ',' ...
           '[brain_dir filesep brain_file{1}]); end'];
set(editact.load_cortex_menu, 'Callback', command);

command = ['vb_browser_show(''' which('job_edit_act.html') ''');'];
set(editact.manual_menu, 'Callback', command);

% Load activity map file
command = ['[act_dir,act_file] = vb_file_select' ...
           '({''.act.mat''},''Load activity map file'');' ...
           'if ~isempty(act_file), ' ...
       'job_edit_act_load_actfile(' inst_str ',' ...
           '[act_dir filesep act_file{1}]); end'];
set(editact.load_actmap_menu, 'Callback', command);
%command = ['job_edit_act_select_file(' inst_str ');'];
%set(editact.pb10,'Callback',command);

% Show loaded files
command = ['job_edit_act_show_loaded_files(' inst_str ');']; 
set(editact.loaded_files_menu, 'Callback', command);

% Close window
command = 'close'; 
set(editact.close_menu,'Callback',command);

% Angle
command = ['job_edit_act_change_angle(' inst_str ',''left'');'];
set(editact.pb16,'Callback',command);
command = ['job_edit_act_change_angle(' inst_str ',''right'');'];
set(editact.pb17,'Callback',command);
command = ['job_edit_act_change_angle(' inst_str ',''top'');'];
set(editact.pb18,'Callback',command);
command = ['job_edit_act_change_angle(' inst_str ',''bottom'');'];
set(editact.pb19,'Callback',command);

% Radio button check
command = ['job_edit_act_change_tal(' inst_str ');'];
set(editact.rb1,'Callback',command);
command = ['job_edit_act_change_mni(' inst_str ');'];
set(editact.rb2,'Callback',command);

% Color scale
command = ['job_edit_act_change_color_scale(' inst_str ');'];
set(editact.ed6,'Callback',command);

% 
% Properties of axis for cortex plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'Renderer','zbuffer');

%
% Set instance
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
vbmeg_inst.editact{inst_id} = editact;

% Set pointer to arrow
set(h_fig,'Pointer','arrow');

% not to show colorbar warning
warning('off', 'MATLAB:colorbar:DeprecatedV6Argument');

%
% Load cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(brainfile),
  job_edit_act_load_cortex(inst_id,brainfile);
end

%
% Load estimated current
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(actfile),
  job_edit_act_load_actfile(inst_id,actfile);
end
