function project_mgr_uimenu_file_callback(fig, hObj)
% callback function for uimenu 'File'.
% [USAGE]
%    project_mgr_uimenu_file_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of project_mgr gui.
%    hObj : event component handle
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('fig', 'var') || isempty(hObj)
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

switch(hObj)
    case H.load_project_menu
        h = file_dialog;
        current_dir = get(H.project_root_edit, 'String');
        if isempty(current_dir)
            current_dir = pwd;
        end
        h = set(h, 'current_dir', current_dir);
        h = set(h, 'file_extensions', {'.prj.mat'});
        h = set(h, 'dialog_title', 'Select project file');
        [dir_name, fnames] = visible(h);
        if ~isempty(dir_name) && ~isempty(fnames{1})
            project_file = [dir_name, filesep, fnames{1}];
            data = project_mgr_load_project_file(project_file, data, fig);
        end
    case H.new_project_menu
        [cancelled, err, project_file] = create_new_project;
        if ~cancelled && ~err
            data = project_mgr_load_project_file(project_file, data, fig);
        end
    case H.output_history_menu
        project_mgr_output_history(fig);
    case H.close_menu
        project_mgr_close(fig);
end
